"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimelineEventItemAnAlert = exports.isAlertFromEndpointEvent = exports.isAlertFromEndpointAlert = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Check to see if a timeline event item is an Alert (vs an event)
 * @param timelineEventItem
 */
const isTimelineEventItemAnAlert = timelineEventItem => {
  return (0, _fp.some)({
    category: 'kibana',
    field: 'kibana.alert.rule.uuid'
  }, timelineEventItem);
};

/**
 * Checks to see if the given set of Timeline event detail items includes data that indicates its
 * an endpoint Alert. Note that it will NOT match on Events - only alerts
 * @param data
 */
exports.isTimelineEventItemAnAlert = isTimelineEventItemAnAlert;
const isAlertFromEndpointEvent = ({
  data
}) => {
  var _find;
  if (!isTimelineEventItemAnAlert(data)) {
    return false;
  }
  const findEndpointAlert = (_find = (0, _fp.find)({
    field: 'agent.type'
  }, data)) === null || _find === void 0 ? void 0 : _find.values;
  return findEndpointAlert ? findEndpointAlert[0] === 'endpoint' : false;
};
exports.isAlertFromEndpointEvent = isAlertFromEndpointEvent;
const isAlertFromEndpointAlert = ({
  ecsData
}) => {
  if (ecsData == null) {
    return false;
  }
  const eventModules = (0, _fp.getOr)([], 'kibana.alert.original_event.module', ecsData);
  const kinds = (0, _fp.getOr)([], 'kibana.alert.original_event.kind', ecsData);
  return eventModules.includes('endpoint') && kinds.includes('alert');
};
exports.isAlertFromEndpointAlert = isAlertFromEndpointAlert;