"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowPagesWithEmptyView = void 0;
var _react = require("react");
var _use_route_spy = require("../route/use_route_spy");
var _types = require("../../../app/types");
var _sourcerer = require("../../containers/sourcerer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Used to detect if we're on a top level page that is empty and set page background color to match the subdued Empty State
const isPageNameWithEmptyView = currentName => {
  const pageNamesWithEmptyView = [_types.SecurityPageName.hosts, _types.SecurityPageName.network, _types.SecurityPageName.timelines, _types.SecurityPageName.overview, _types.SecurityPageName.users];
  return pageNamesWithEmptyView.includes(currentName);
};
const useShowPagesWithEmptyView = () => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const {
    indicesExist
  } = (0, _sourcerer.useSourcererDataView)();
  const shouldShowEmptyState = isPageNameWithEmptyView(pageName) && !indicesExist;
  const [showEmptyState, setShowEmptyState] = (0, _react.useState)(shouldShowEmptyState);
  (0, _react.useEffect)(() => {
    if (shouldShowEmptyState) {
      setShowEmptyState(true);
    } else {
      setShowEmptyState(false);
    }
  }, [shouldShowEmptyState]);
  return showEmptyState;
};
exports.useShowPagesWithEmptyView = useShowPagesWithEmptyView;