"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReducer = exports.createInitialState = void 0;
var _redux = require("redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _immer = require("immer");
var _app = require("./app");
var _drag_and_drop = require("./drag_and_drop");
var _inputs = require("./inputs");
var _sourcerer = require("./sourcerer");
var _model = require("./sourcerer/model");
var _helpers = require("./sourcerer/helpers");
var _global_url_param = require("./global_url_param");
var _reducer = require("./grouping/reducer");
var _reducer2 = require("../../resolver/store/reducer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

(0, _immer.enableMapSet)();
/**
 * Factory for the 'initialState' that is used to preload state into the Security App's redux store.
 */
const createInitialState = (pluginsInitState, {
  defaultDataView,
  kibanaDataViews,
  signalIndexName,
  enableExperimental
}, dataTableState, groupsState, analyzerState) => {
  const initialPatterns = {
    [_model.SourcererScopeName.default]: (0, _helpers.getScopePatternListSelection)(defaultDataView, _model.SourcererScopeName.default, signalIndexName, true),
    [_model.SourcererScopeName.detections]: (0, _helpers.getScopePatternListSelection)(defaultDataView, _model.SourcererScopeName.detections, signalIndexName, true),
    [_model.SourcererScopeName.timeline]: (0, _helpers.getScopePatternListSelection)(defaultDataView, _model.SourcererScopeName.timeline, signalIndexName, true)
  };
  const preloadedState = {
    ...pluginsInitState,
    app: {
      ..._app.initialAppState,
      enableExperimental
    },
    dragAndDrop: _drag_and_drop.initialDragAndDropState,
    inputs: (0, _inputs.createInitialInputsState)(enableExperimental.socTrendsEnabled),
    sourcerer: {
      ..._sourcerer.sourcererModel.initialSourcererState,
      sourcererScopes: {
        ..._sourcerer.sourcererModel.initialSourcererState.sourcererScopes,
        [_model.SourcererScopeName.default]: {
          ..._sourcerer.sourcererModel.initialSourcererState.sourcererScopes.default,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: initialPatterns[_model.SourcererScopeName.default]
        },
        [_model.SourcererScopeName.detections]: {
          ..._sourcerer.sourcererModel.initialSourcererState.sourcererScopes.detections,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: initialPatterns[_model.SourcererScopeName.detections]
        },
        [_model.SourcererScopeName.timeline]: {
          ..._sourcerer.sourcererModel.initialSourcererState.sourcererScopes.timeline,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: initialPatterns[_model.SourcererScopeName.timeline]
        }
      },
      defaultDataView,
      kibanaDataViews: kibanaDataViews.map(dataView => ({
        ..._model.initDataView,
        ...dataView
      })),
      signalIndexName
    },
    globalUrlParam: _global_url_param.initialGlobalUrlParam,
    dataTable: dataTableState.dataTable,
    groups: groupsState.groups,
    analyzer: analyzerState.analyzer
  };
  return preloadedState;
};

/**
 * Factory for the Security app's redux reducer.
 */
exports.createInitialState = createInitialState;
const createReducer = pluginsReducer => (0, _redux.combineReducers)({
  app: _app.appReducer,
  dragAndDrop: _drag_and_drop.dragAndDropReducer,
  inputs: _inputs.inputsReducer,
  sourcerer: _sourcerer.sourcererReducer,
  globalUrlParam: _global_url_param.globalUrlParamReducer,
  dataTable: _securitysolutionDataTable.dataTableReducer,
  groups: _reducer.groupsReducer,
  analyzer: _reducer2.analyzerReducer,
  ...pluginsReducer
});
exports.createReducer = createReducer;