"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRootProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _mock_assistant_provider = require("../mock_assistant_provider");
var _route_capture = require("../../components/endpoint/route_capture");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the context for rendering the endpoint app
 */
const AppRootProvider = /*#__PURE__*/(0, _react.memo)(({
  store,
  history,
  coreStart: {
    http,
    notifications,
    uiSettings,
    application
  },
  depsStart: {
    data
  },
  children
}) => {
  const isDarkMode = (0, _useObservable.default)(uiSettings.get$('theme:darkMode'));
  const services = (0, _react.useMemo)(() => ({
    http,
    notifications,
    application,
    data
  }), [application, data, http, notifications]);
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, null, children)))))));
});
exports.AppRootProvider = AppRootProvider;
AppRootProvider.displayName = 'AppRootProvider';