"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeepLinksUpdater = void 0;
var _public = require("@kbn/core/public");
var _links = require("./links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatDeepLinks = appLinks => appLinks.map(appLink => {
  var _appLink$links;
  return {
    id: appLink.id,
    path: appLink.path,
    title: appLink.title,
    searchable: !appLink.globalSearchDisabled,
    ...(appLink.globalNavPosition != null ? {
      navLinkStatus: _public.AppNavLinkStatus.visible,
      order: appLink.globalNavPosition
    } : {
      navLinkStatus: _public.AppNavLinkStatus.hidden
    }),
    ...(appLink.globalSearchKeywords != null ? {
      keywords: appLink.globalSearchKeywords
    } : {}),
    ...(appLink.links && (_appLink$links = appLink.links) !== null && _appLink$links !== void 0 && _appLink$links.length ? {
      deepLinks: formatDeepLinks(appLink.links)
    } : {})
  };
});

/**
 * Registers any change in appLinks to be updated in app deepLinks
 */
const registerDeepLinksUpdater = appUpdater$ => {
  return _links.appLinks$.subscribe(appLinks => {
    appUpdater$.next(() => ({
      navLinkStatus: _public.AppNavLinkStatus.hidden,
      // needed to prevent main security link to switch to visible after update
      deepLinks: formatDeepLinks(appLinks)
    }));
  });
};
exports.registerDeepLinksUpdater = registerDeepLinksUpdater;