"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaServices = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class KibanaServices {
  static init({
    http,
    application,
    data,
    unifiedSearch,
    kibanaBranch,
    kibanaVersion,
    prebuiltRulesPackageVersion,
    uiSettings,
    notifications
  }) {
    this.services = {
      application,
      data,
      http,
      uiSettings,
      unifiedSearch,
      notifications
    };
    this.kibanaBranch = kibanaBranch;
    this.kibanaVersion = kibanaVersion;
    this.prebuiltRulesPackageVersion = prebuiltRulesPackageVersion;
  }
  static get() {
    if (!this.services) {
      this.throwUninitializedError();
    }
    return this.services;
  }
  static getKibanaBranch() {
    if (!this.kibanaBranch) {
      this.throwUninitializedError();
    }
    return this.kibanaBranch;
  }
  static getKibanaVersion() {
    if (!this.kibanaVersion) {
      this.throwUninitializedError();
    }
    return this.kibanaVersion;
  }
  static getPrebuiltRulesPackageVersion() {
    return this.prebuiltRulesPackageVersion;
  }
  static throwUninitializedError() {
    throw new Error('Kibana services not initialized - are you trying to import this module from outside of the SIEM app?');
  }
}
exports.KibanaServices = KibanaServices;
(0, _defineProperty2.default)(KibanaServices, "kibanaBranch", void 0);
(0, _defineProperty2.default)(KibanaServices, "kibanaVersion", void 0);
(0, _defineProperty2.default)(KibanaServices, "prebuiltRulesPackageVersion", void 0);
(0, _defineProperty2.default)(KibanaServices, "services", void 0);