"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlState = exports.URL_PARAM_KEY = void 0;
var _global_query_string = require("../utils/global_query_string");
var _use_init_search_bar_url_params = require("./search_bar/use_init_search_bar_url_params");
var _use_init_timerange_url_params = require("./search_bar/use_init_timerange_url_params");
var _use_update_timerange_on_page_change = require("./search_bar/use_update_timerange_on_page_change");
var _use_init_timeline_url_param = require("./timeline/use_init_timeline_url_param");
var _use_sync_timeline_url_param = require("./timeline/use_sync_timeline_url_param");
var _use_query_timeline_by_id_on_url_change = require("./timeline/use_query_timeline_by_id_on_url_change");
var _use_init_flyout_url_param = require("./flyout/use_init_flyout_url_param");
var _use_sync_flyout_url_param = require("./flyout/use_sync_flyout_url_param");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: the expandable flyout package url state is handled here:
// x-pack/plugins/security_solution/public/flyout/url/use_sync_flyout_state_with_url.tsx

const useUrlState = () => {
  (0, _global_query_string.useSyncGlobalQueryString)();
  (0, _use_init_search_bar_url_params.useInitSearchBarFromUrlParams)();
  (0, _use_init_timerange_url_params.useInitTimerangeFromUrlParam)();
  (0, _use_update_timerange_on_page_change.useUpdateTimerangeOnPageChange)();
  (0, _use_init_timeline_url_param.useInitTimelineFromUrlParam)();
  (0, _use_sync_timeline_url_param.useSyncTimelineUrlParam)();
  (0, _use_query_timeline_by_id_on_url_change.useQueryTimelineByIdOnUrlChange)();
  (0, _use_init_flyout_url_param.useInitFlyoutFromUrlParam)();
  (0, _use_sync_flyout_url_param.useSyncFlyoutUrlParam)();
};
exports.useUrlState = useUrlState;
let URL_PARAM_KEY;
exports.URL_PARAM_KEY = URL_PARAM_KEY;
(function (URL_PARAM_KEY) {
  URL_PARAM_KEY["appQuery"] = "query";
  URL_PARAM_KEY["eventFlyout"] = "eventFlyout";
  URL_PARAM_KEY["filters"] = "filters";
  URL_PARAM_KEY["savedQuery"] = "savedQuery";
  URL_PARAM_KEY["sourcerer"] = "sourcerer";
  URL_PARAM_KEY["timeline"] = "timeline";
  URL_PARAM_KEY["timerange"] = "timerange";
  URL_PARAM_KEY["pageFilter"] = "pageFilters";
  URL_PARAM_KEY["rulesTable"] = "rulesTable";
})(URL_PARAM_KEY || (exports.URL_PARAM_KEY = URL_PARAM_KEY = {}));