"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpsellingPage = exports.useUpsellingComponent = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpsellingComponent = id => {
  const {
    upselling
  } = (0, _kibana.useKibana)().services;
  const upsellingSections = (0, _useObservable.default)(upselling.sections$);
  return (0, _react.useMemo)(() => {
    var _upsellingSections$ge;
    return (_upsellingSections$ge = upsellingSections === null || upsellingSections === void 0 ? void 0 : upsellingSections.get(id)) !== null && _upsellingSections$ge !== void 0 ? _upsellingSections$ge : null;
  }, [id, upsellingSections]);
};
exports.useUpsellingComponent = useUpsellingComponent;
const useUpsellingPage = pageName => {
  const {
    upselling
  } = (0, _kibana.useKibana)().services;
  const UpsellingPage = (0, _react.useMemo)(() => upselling.getPageUpselling(pageName), [pageName, upselling]);
  return UpsellingPage !== null && UpsellingPage !== void 0 ? UpsellingPage : null;
};
exports.useUpsellingPage = useUpsellingPage;