"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateBrowserTitle = void 0;
var _react = require("react");
var _links = require("../links");
var _use_route_spy = require("../utils/route/use_route_spy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateBrowserTitle = () => {
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const linkInfo = (0, _links.getLinkInfo)(pageName);
  (0, _react.useEffect)(() => {
    var _linkInfo$title;
    document.title = `${(_linkInfo$title = linkInfo === null || linkInfo === void 0 ? void 0 : linkInfo.title) !== null && _linkInfo$title !== void 0 ? _linkInfo$title : ''} - Kibana`;
  }, [pageName, linkInfo]);
};
exports.useUpdateBrowserTitle = useUpdateBrowserTitle;