"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyncTimelineUrlParam = void 0;
var _react = require("react");
var _global_query_string = require("../../utils/global_query_string");
var _timeline = require("../../../timelines/store/timeline");
var _types = require("../../../../common/types");
var _use_selector = require("../use_selector");
var _use_url_state = require("../use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSyncTimelineUrlParam = () => {
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.timeline);
  const getTimeline = (0, _react.useMemo)(() => _timeline.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    activeTab,
    graphEventId,
    show,
    savedObjectId
  } = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, _types.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : {};
  });
  (0, _react.useEffect)(() => {
    updateUrlParam(savedObjectId != null ? {
      id: savedObjectId,
      isOpen: show,
      activeTab,
      graphEventId: graphEventId !== null && graphEventId !== void 0 ? graphEventId : ''
    } : null);
  }, [activeTab, graphEventId, savedObjectId, show, updateUrlParam]);
};
exports.useSyncTimelineUrlParam = useSyncTimelineUrlParam;