"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEqlPreview = void 0;
var _react = require("react");
var _fp = require("lodash/fp");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/kibana-utils-plugin/common");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana = require("../../lib/kibana");
var _helpers = require("./helpers");
var _utils = require("../../../../common/detection_engine/utils");
var _use_app_toasts = require("../use_app_toasts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEqlPreview = () => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const unsubscribeStream = (0, _react.useRef)(new _rxjs.Subject());
  const [loading, setLoading] = (0, _react.useState)(false);
  const didCancel = (0, _react.useRef)(false);
  const {
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const [response, setResponse] = (0, _react.useState)({
    data: [],
    inspect: {
      dsl: [],
      response: []
    },
    refetch: refetch.current,
    totalCount: 0
  });
  const searchEql = (0, _react.useCallback)(({
    from,
    to,
    query,
    index,
    interval
  }) => {
    if ((0, _securitysolutionIoTsUtils.parseScheduleDates)(to) == null || (0, _securitysolutionIoTsUtils.parseScheduleDates)(from) == null) {
      addWarning(i18n.EQL_TIME_INTERVAL_NOT_DEFINED);
      return;
    }
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      setResponse(prevResponse => ({
        ...prevResponse,
        data: [],
        inspect: {
          dsl: [],
          response: []
        },
        totalCount: 0
      }));
      data.search.search({
        params: {
          index: index.join(),
          body: {
            filter: {
              range: {
                '@timestamp': {
                  gte: from,
                  lte: to,
                  format: 'strict_date_optional_time'
                }
              }
            },
            query,
            // EQL requires a cap, otherwise it defaults to 10
            // It also sorts on ascending order, capping it at
            // something smaller like 20, made it so that some of
            // the more recent events weren't returned
            size: 100
          }
        }
      }, {
        strategy: _common.EQL_SEARCH_STRATEGY,
        abortSignal: abortCtrl.current.signal
      }).pipe((0, _operators.takeUntil)(unsubscribeStream.current)).subscribe({
        next: res => {
          if ((0, _common.isCompleteResponse)(res)) {
            if (!didCancel.current) {
              setLoading(false);
              setResponse(prev => {
                const {
                  inspect,
                  ...rest
                } = (0, _helpers.getEqlAggsData)(res, interval, to, refetch.current, index, (0, _utils.hasEqlSequenceQuery)(query));
                const inspectDsl = prev.inspect.dsl[0] ? prev.inspect.dsl : inspect.dsl;
                const inspectResp = prev.inspect.response[0] ? prev.inspect.response : inspect.response;
                return {
                  ...prev,
                  ...rest,
                  inspect: {
                    dsl: inspectDsl,
                    response: inspectResp
                  }
                };
              });
            }
            unsubscribeStream.current.next();
          } else if ((0, _common.isPartialResponse)(res)) {
            // TODO: Eql search strategy partial responses return a value under meta.params.body
            // but the final/complete response does not, that's why the inspect values are set here
            setResponse(prev => ({
              ...prev,
              inspect: (0, _helpers.formatInspect)(res, index)
            }));
          } else if ((0, _common.isErrorResponse)(res)) {
            setLoading(false);
            addWarning(i18n.EQL_PREVIEW_FETCH_FAILURE);
            unsubscribeStream.current.next();
          }
        },
        error: err => {
          if (!(err instanceof _common2.AbortError)) {
            setLoading(false);
            setResponse({
              data: [],
              inspect: {
                dsl: [],
                response: []
              },
              refetch: refetch.current,
              totalCount: 0
            });
            addError(err, {
              title: i18n.EQL_PREVIEW_FETCH_FAILURE
            });
          }
        }
      });
    };
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, addError, addWarning]);
  (0, _react.useEffect)(() => {
    return () => {
      didCancel.current = true;
      abortCtrl.current.abort();
      // eslint-disable-next-line react-hooks/exhaustive-deps
      unsubscribeStream.current.complete();
    };
  }, []);
  return [loading, searchEql, response];
};
exports.useEqlPreview = useEqlPreview;