"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTIONS_ALERTS_COUNT_ID = void 0;
exports.useAlertPrevalenceFromProcessTree = useAlertPrevalenceFromProcessTree;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../lib/kibana");
var _use_timeline_data_filters = require("../../../timelines/containers/use_timeline_data_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTIONS_ALERTS_COUNT_ID = 'detections-alerts-count';
exports.DETECTIONS_ALERTS_COUNT_ID = DETECTIONS_ALERTS_COUNT_ID;
function useAlertDocumentAnalyzerSchema({
  documentId,
  indices
}) {
  const http = (0, _kibana.useHttp)();
  const query = (0, _reactQuery.useQuery)(['getAlertPrevalenceSchema', documentId], () => {
    return http.get(`/api/endpoint/resolver/entity`, {
      query: {
        _id: documentId,
        indices
      }
    });
  });
  if (query.isLoading) {
    return {
      loading: true,
      error: false,
      id: null,
      schema: null
    };
  } else if (query.data && query.data.length > 0) {
    const {
      data: [{
        schema,
        id
      }]
    } = query;
    return {
      loading: false,
      error: false,
      id,
      schema
    };
  } else {
    return {
      loading: false,
      error: true,
      id: null,
      schema: null
    };
  }
}
function useAlertPrevalenceFromProcessTree({
  documentId,
  isActiveTimeline,
  indices
}) {
  const http = (0, _kibana.useHttp)();
  const {
    selectedPatterns
  } = (0, _use_timeline_data_filters.useTimelineDataFilters)(isActiveTimeline);
  const alertAndOriginalIndices = [...new Set(selectedPatterns.concat(indices))];
  const {
    loading,
    id,
    schema
  } = useAlertDocumentAnalyzerSchema({
    documentId,
    indices: alertAndOriginalIndices
  });
  const query = (0, _reactQuery.useQuery)(['getAlertPrevalenceFromProcessTree', id], () => {
    return http.post(`/api/endpoint/resolver/tree`, {
      body: JSON.stringify({
        schema,
        ancestors: 200,
        descendants: 500,
        indexPatterns: alertAndOriginalIndices,
        nodes: [id],
        includeHits: true
      })
    });
  }, {
    enabled: schema !== null && id !== null
  });
  if (query.isLoading || loading) {
    return {
      loading: true,
      error: false,
      alertIds: undefined,
      statsNodes: undefined
    };
  } else if (query.data) {
    return {
      loading: false,
      error: false,
      alertIds: query.data.alertIds,
      statsNodes: query.data.statsNodes
    };
  } else {
    return {
      loading: false,
      error: true,
      alertIds: undefined,
      statsNodes: undefined
    };
  }
}