"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertPrevalence = void 0;
var _react = require("react");
var _constants = require("../../../../common/constants");
var _use_global_time = require("../use_global_time");
var _use_query = require("../../../detections/containers/detection_engine/alerts/use_query");
var _constants2 = require("../../../detections/containers/detection_engine/alerts/constants");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_PREVALENCE_AGG = 'countOfAlertsWithSameFieldAndValue';
const useAlertPrevalence = ({
  field,
  value,
  isActiveTimelines,
  signalIndexName,
  includeAlertIds = false,
  ignoreTimerange = false
}) => {
  const timelineTime = (0, _use_selector.useDeepEqualSelector)(state => _store.inputsSelectors.timelineTimeRangeSelector(state));
  const globalTime = (0, _use_global_time.useGlobalTime)();
  let to;
  let from;
  if (ignoreTimerange === false) {
    ({
      to,
      from
    } = isActiveTimelines ? timelineTime : globalTime);
  }
  const [initialQuery] = (0, _react.useState)(() => generateAlertPrevalenceQuery(field, value, from, to, includeAlertIds));
  const {
    loading,
    data,
    setQuery
  } = (0, _use_query.useQueryAlerts)({
    query: initialQuery,
    indexName: signalIndexName,
    queryName: _constants2.ALERTS_QUERY_NAMES.PREVALENCE
  });
  (0, _react.useEffect)(() => {
    setQuery(generateAlertPrevalenceQuery(field, value, from, to, includeAlertIds));
  }, [setQuery, field, value, from, to, includeAlertIds]);
  let count;
  if (data) {
    var _data$aggregations, _data$aggregations$AL;
    const buckets = (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$AL = _data$aggregations[ALERT_PREVALENCE_AGG]) === null || _data$aggregations$AL === void 0 ? void 0 : _data$aggregations$AL.buckets;
    if (buckets && buckets.length > 0) {
      count = buckets[0].doc_count;
    }
  }
  const error = !loading && count === undefined;
  return (0, _react.useMemo)(() => ({
    loading,
    count,
    error,
    alertIds: data === null || data === void 0 ? void 0 : data.hits.hits.map(({
      _id
    }) => _id)
  }), [count, data, error, loading]);
};
exports.useAlertPrevalence = useAlertPrevalence;
const generateAlertPrevalenceQuery = (field, value, from, to, includeAlertIds) => {
  // if we don't want the alert ids included, we set size to 0 to reduce the response payload
  const size = includeAlertIds ? {
    size: _constants.DEFAULT_MAX_TABLE_QUERY_SIZE
  } : {
    size: 0
  };
  // in that case, we also want to make sure we're sorting the results by timestamp
  const sort = includeAlertIds ? {
    sort: {
      '@timestamp': 'desc'
    }
  } : {};
  const actualValue = Array.isArray(value) && value.length === 1 ? value[0] : value;
  let query;
  query = {
    bool: {
      must: {
        match: {
          [field]: actualValue
        }
      }
    }
  };
  if (from !== undefined && to !== undefined) {
    query = {
      ...query,
      bool: {
        ...query.bool,
        filter: [{
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }]
      }
    };
  }

  // If we search for the prevalence of a field that has multiple values (e.g. process.args),
  // we want to find alerts with the exact same values.
  if (Array.isArray(value) && value.length > 1) {
    query = {
      bool: {
        must: value.map(term => ({
          term: {
            [field]: term
          }
        }))
      }
    };
    if (from !== undefined && to !== undefined) {
      query.bool.must.push({
        range: {
          '@timestamp': {
            gte: from,
            lte: to
          }
        }
      });
    }
  }
  return {
    ...size,
    ...sort,
    _source: false,
    aggs: {
      [ALERT_PREVALENCE_AGG]: {
        terms: {
          field,
          size: _constants.DEFAULT_MAX_TABLE_QUERY_SIZE
        }
      }
    },
    query,
    runtime_mappings: {}
  };
};