"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddToNewCase = void 0;
var _react = require("react");
var _common = require("@kbn/cases-plugin/common");
var _kibana = require("../../lib/kibana");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddToNewCase = ({
  onClick,
  timeRange,
  lensAttributes
}) => {
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const attachments = (0, _react.useMemo)(() => {
    return [{
      persistableStateAttachmentState: {
        attributes: lensAttributes,
        timeRange
      },
      persistableStateAttachmentTypeId: _common.LENS_ATTACHMENT_TYPE,
      type: _common.CommentType.persistableState
    }];
  }, [lensAttributes, timeRange]);
  const createCaseFlyout = cases.hooks.useCasesAddToNewCaseFlyout({
    toastContent: _translations.ADD_TO_CASE_SUCCESS
  });
  const onAddToNewCaseClicked = (0, _react.useCallback)(() => {
    if (onClick) {
      onClick();
    }
    createCaseFlyout.open({
      attachments
    });
  }, [attachments, createCaseFlyout, onClick]);
  return {
    onAddToNewCaseClicked,
    disabled: lensAttributes == null || timeRange == null || !userCasesPermissions.create || !userCasesPermissions.read
  };
};
exports.useAddToNewCase = useAddToNewCase;