"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dispatchUpdateSearch = exports.connector = exports.SiemSearchBar = exports.SearchBarComponent = void 0;
var _fp = require("@kbn/safer-lodash-set/fp");
var _fp2 = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _inputs = require("../../store/inputs");
var _super_date_picker = require("../super_date_picker");
var _selectors = require("./selectors");
var _timeline = require("../../../timelines/store/timeline");
var _kibana = require("../../lib/kibana");
var _store = require("../../../explore/users/store");
var _store2 = require("../../../explore/hosts/store");
var _store3 = require("../../../explore/network/store");
var _use_sync_search_bar_url_param = require("../../hooks/search_bar/use_sync_search_bar_url_param");
var _use_sync_timerange_url_param = require("../../hooks/search_bar/use_sync_timerange_url_param");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchBarComponent = /*#__PURE__*/(0, _react.memo)(({
  end,
  filterQuery,
  fromStr,
  hideFilterBar = false,
  hideQueryInput = false,
  id,
  indexPattern,
  isLoading = false,
  pollForSignalIndex,
  queries,
  savedQuery,
  setSavedQuery,
  setSearchBarFilter,
  start,
  toStr,
  updateSearch,
  dataTestSubj
}) => {
  const {
    data: {
      query: {
        timefilter: {
          timefilter
        },
        filterManager
      }
    },
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const setTablesActivePageToZero = (0, _react.useCallback)(() => {
    dispatch(_store.usersActions.setUsersTablesActivePageToZero());
    dispatch(_store2.hostsActions.setHostTablesActivePageToZero());
    dispatch(_store3.networkActions.setNetworkTablesActivePageToZero());
  }, [dispatch]);
  (0, _use_sync_search_bar_url_param.useSyncSearchBarUrlParams)();
  (0, _use_sync_timerange_url_param.useSyncTimerangeUrlParam)();
  (0, _react.useEffect)(() => {
    if (fromStr != null && toStr != null) {
      timefilter.setTime({
        from: fromStr,
        to: toStr
      });
    } else if (start != null && end != null) {
      setTablesActivePageToZero();
      timefilter.setTime({
        from: new Date(start).toISOString(),
        to: new Date(end).toISOString()
      });
    }
  }, [end, fromStr, start, timefilter, toStr, setTablesActivePageToZero]);
  const onQuerySubmit = (0, _react.useCallback)(payload => {
    // if the function is there, call it to check if the signals index exists yet
    // in order to update the index fields
    if (pollForSignalIndex != null) {
      pollForSignalIndex();
    }
    const isQuickSelection = payload.dateRange.from.includes('now') || payload.dateRange.to.includes('now');
    let updateSearchBar = {
      id,
      end: toStr != null ? toStr : new Date(end).toISOString(),
      start: fromStr != null ? fromStr : new Date(start).toISOString(),
      isInvalid: false,
      isQuickSelection,
      updateTime: false,
      filterManager,
      setTablesActivePageToZero
    };
    let isStateUpdated = false;
    if (isQuickSelection && (fromStr !== payload.dateRange.from || toStr !== payload.dateRange.to) || !isQuickSelection && (start !== (0, _super_date_picker.formatDate)(payload.dateRange.from) || end !== (0, _super_date_picker.formatDate)(payload.dateRange.to))) {
      isStateUpdated = true;
      updateSearchBar.updateTime = true;
      updateSearchBar.end = payload.dateRange.to;
      updateSearchBar.start = payload.dateRange.from;
    }
    if (payload.query != null && !(0, _fastDeepEqual.default)(payload.query, filterQuery)) {
      isStateUpdated = true;
      updateSearchBar = (0, _fp.set)('query', payload.query, updateSearchBar);
    }
    if (!isStateUpdated) {
      // That mean we are doing a refresh!
      if (isQuickSelection && payload.dateRange.to !== payload.dateRange.from) {
        updateSearchBar.updateTime = true;
        updateSearchBar.end = payload.dateRange.to;
        updateSearchBar.start = payload.dateRange.from;
      } else {
        queries.forEach(q => q.refetch && q.refetch());
      }
    }
    window.setTimeout(() => updateSearch(updateSearchBar), 0);
  }, [id, pollForSignalIndex, toStr, end, fromStr, start, filterManager, filterQuery, queries, updateSearch, setTablesActivePageToZero]);
  const onRefresh = (0, _react.useCallback)(payload => {
    if (payload.dateRange.from.includes('now') || payload.dateRange.to.includes('now')) {
      updateSearch({
        id,
        end: payload.dateRange.to,
        start: payload.dateRange.from,
        isInvalid: false,
        isQuickSelection: true,
        updateTime: true,
        filterManager,
        setTablesActivePageToZero
      });
    } else {
      queries.forEach(q => q.refetch && q.refetch());
    }
  }, [updateSearch, id, filterManager, queries, setTablesActivePageToZero]);
  const onSaved = (0, _react.useCallback)(newSavedQuery => {
    setSavedQuery({
      id,
      savedQuery: newSavedQuery
    });
  }, [id, setSavedQuery]);
  const onSavedQueryUpdated = (0, _react.useCallback)(savedQueryUpdated => {
    const isQuickSelection = savedQueryUpdated.attributes.timefilter ? savedQueryUpdated.attributes.timefilter.from.includes('now') || savedQueryUpdated.attributes.timefilter.to.includes('now') : false;
    let updateSearchBar = {
      id,
      filters: savedQueryUpdated.attributes.filters || [],
      end: toStr != null ? toStr : new Date(end).toISOString(),
      start: fromStr != null ? fromStr : new Date(start).toISOString(),
      isInvalid: false,
      isQuickSelection,
      updateTime: false,
      filterManager,
      setTablesActivePageToZero
    };
    if (savedQueryUpdated.attributes.timefilter) {
      updateSearchBar.end = savedQueryUpdated.attributes.timefilter ? savedQueryUpdated.attributes.timefilter.to : updateSearchBar.end;
      updateSearchBar.start = savedQueryUpdated.attributes.timefilter ? savedQueryUpdated.attributes.timefilter.from : updateSearchBar.start;
      updateSearchBar.updateTime = true;
    }
    updateSearchBar = (0, _fp.set)('query', savedQueryUpdated.attributes.query, updateSearchBar);
    updateSearchBar = (0, _fp.set)('savedQuery', savedQueryUpdated, updateSearchBar);
    updateSearch(updateSearchBar);
  }, [id, toStr, end, fromStr, start, filterManager, updateSearch, setTablesActivePageToZero]);
  const onClearSavedQuery = (0, _react.useCallback)(() => {
    if (savedQuery != null) {
      updateSearch({
        id,
        filters: [],
        end: toStr != null ? toStr : new Date(end).toISOString(),
        start: fromStr != null ? fromStr : new Date(start).toISOString(),
        isInvalid: false,
        isQuickSelection: false,
        updateTime: false,
        query: {
          query: '',
          language: savedQuery.attributes.query.language
        },
        resetSavedQuery: true,
        savedQuery: undefined,
        filterManager,
        setTablesActivePageToZero
      });
    }
  }, [savedQuery, updateSearch, id, toStr, end, fromStr, start, filterManager, setTablesActivePageToZero]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(filterManager.getUpdates$().subscribe({
      next: () => {
        if (isSubscribed) {
          const filters = filterManager.getFilters();
          setSearchBarFilter({
            id,
            filters
          });
          setTablesActivePageToZero();
        }
      }
    }));
    return () => {
      isSubscribed = false;
      subscriptions.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const indexPatterns = (0, _react.useMemo)(() => [indexPattern], [indexPattern]);
  const onTimeRangeChange = (0, _react.useCallback)(({
    query,
    dateRange
  }) => {
    const isQuickSelection = dateRange.from.includes('now') || dateRange.to.includes('now');
    updateSearch({
      end: dateRange.to,
      filterManager,
      id,
      isInvalid: false,
      isQuickSelection,
      query,
      setTablesActivePageToZero,
      start: dateRange.from,
      updateTime: true
    });
  }, [filterManager, id, setTablesActivePageToZero, updateSearch]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${id}DatePicker`
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "siem",
    isLoading: isLoading,
    indexPatterns: indexPatterns,
    query: filterQuery,
    onClearSavedQuery: onClearSavedQuery,
    onQuerySubmit: onQuerySubmit,
    onRefresh: onRefresh,
    onSaved: onSaved,
    onTimeRangeChange: onTimeRangeChange,
    onSavedQueryUpdated: onSavedQueryUpdated,
    savedQuery: savedQuery,
    showFilterBar: !hideFilterBar,
    showDatePicker: true,
    showQueryInput: !hideQueryInput,
    showSaveQuery: true,
    dataTestSubj: dataTestSubj
  }));
}, (prevProps, nextProps) => prevProps.end === nextProps.end && prevProps.filterQuery === nextProps.filterQuery && prevProps.fromStr === nextProps.fromStr && prevProps.id === nextProps.id && prevProps.isLoading === nextProps.isLoading && prevProps.savedQuery === nextProps.savedQuery && prevProps.setSavedQuery === nextProps.setSavedQuery && prevProps.setSearchBarFilter === nextProps.setSearchBarFilter && prevProps.start === nextProps.start && prevProps.toStr === nextProps.toStr && prevProps.updateSearch === nextProps.updateSearch && prevProps.dataTestSubj === nextProps.dataTestSubj && (0, _fastDeepEqual.default)(prevProps.indexPattern, nextProps.indexPattern) && (0, _fastDeepEqual.default)(prevProps.queries, nextProps.queries));
exports.SearchBarComponent = SearchBarComponent;
const makeMapStateToProps = () => {
  const getEndSelector = (0, _selectors.endSelector)();
  const getFromStrSelector = (0, _selectors.fromStrSelector)();
  const getIsLoadingSelector = (0, _selectors.isLoadingSelector)();
  const getQueriesSelector = (0, _selectors.queriesSelector)();
  const getStartSelector = (0, _selectors.startSelector)();
  const getToStrSelector = (0, _selectors.toStrSelector)();
  const getFilterQuerySelector = (0, _selectors.filterQuerySelector)();
  const getSavedQuerySelector = (0, _selectors.savedQuerySelector)();
  return (state, {
    id
  }) => {
    const inputsRange = (0, _fp2.getOr)({}, `inputs.${id}`, state);
    return {
      end: getEndSelector(inputsRange),
      fromStr: getFromStrSelector(inputsRange),
      filterQuery: getFilterQuerySelector(inputsRange),
      isLoading: getIsLoadingSelector(inputsRange),
      queries: getQueriesSelector(state, id),
      savedQuery: getSavedQuerySelector(inputsRange),
      start: getStartSelector(inputsRange),
      toStr: getToStrSelector(inputsRange)
    };
  };
};
SearchBarComponent.displayName = 'SiemSearchBar';
const dispatchUpdateSearch = dispatch => ({
  end,
  filters,
  id,
  isQuickSelection,
  query,
  resetSavedQuery,
  savedQuery,
  start,
  timelineId,
  updateTime = false,
  filterManager,
  setTablesActivePageToZero
}) => {
  if (updateTime) {
    const fromDate = (0, _super_date_picker.formatDate)(start);
    let toDate = (0, _super_date_picker.formatDate)(end, {
      roundUp: true
    });
    if (isQuickSelection) {
      if (end === start) {
        dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
          id,
          fromStr: start,
          toStr: end,
          from: fromDate,
          to: toDate
        }));
      } else {
        dispatch(_inputs.inputsActions.setRelativeRangeDatePicker({
          id,
          fromStr: start,
          toStr: end,
          from: fromDate,
          to: toDate
        }));
      }
    } else {
      toDate = (0, _super_date_picker.formatDate)(end);
      dispatch(_inputs.inputsActions.setAbsoluteRangeDatePicker({
        id,
        from: (0, _super_date_picker.formatDate)(start),
        to: (0, _super_date_picker.formatDate)(end)
      }));
    }
    if (timelineId != null) {
      dispatch(_timeline.timelineActions.updateRange({
        id: timelineId,
        start: fromDate,
        end: toDate
      }));
    }
  }
  if (query != null) {
    dispatch(_inputs.inputsActions.setFilterQuery({
      id,
      ...query
    }));
  }
  if (filters != null) {
    filterManager.setFilters(filters);
  }
  if (savedQuery != null || resetSavedQuery) {
    dispatch(_inputs.inputsActions.setSavedQuery({
      id,
      savedQuery
    }));
  }
  setTablesActivePageToZero();
};
exports.dispatchUpdateSearch = dispatchUpdateSearch;
const mapDispatchToProps = dispatch => ({
  updateSearch: dispatchUpdateSearch(dispatch),
  setSavedQuery: ({
    id,
    savedQuery
  }) => dispatch(_inputs.inputsActions.setSavedQuery({
    id,
    savedQuery
  })),
  setSearchBarFilter: ({
    id,
    filters
  }) => dispatch(_inputs.inputsActions.setSearchBarFilter({
    id,
    filters
  }))
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
exports.connector = connector;
const SiemSearchBar = connector(SearchBarComponent);
exports.SiemSearchBar = SiemSearchBar;