"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Paywall = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _kibana = require("../../lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _entity_paywall = _interopRequireDefault(require("../../images/entity_paywall.png"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PaywallDiv = _styledComponents.default.div`
  max-width: 75%;
  margin: 0 auto;
  .euiCard__betaBadgeWrapper {
    .euiCard__betaBadge {
      width: auto;
    }
  }
  .platinumCardDescription {
    padding: 0 15%;
  }
`;
const StyledEuiCard = (0, _styledComponents.default)(_eui.EuiCard)`
  span.euiTitle {
    max-width: 540px;
    display: block;
    margin: 0 auto;
  }
`;
const Paywall = /*#__PURE__*/(0, _react.memo)(({
  heading
}) => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const subscriptionUrl = getAppUrl({
    appId: 'management',
    path: 'stack/license_management'
  });
  const goToSubscription = (0, _react.useCallback)(() => {
    navigateTo({
      url: subscriptionUrl
    });
  }, [navigateTo, subscriptionUrl]);
  return /*#__PURE__*/_react.default.createElement(PaywallDiv, null, /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    "data-test-subj": "platinumCard",
    betaBadgeProps: {
      label: i18n.PLATINUM
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock"
    }),
    display: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement("strong", null, heading)),
    description: false,
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "platinumCardDescription",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, i18n.UPGRADE_MESSAGE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: goToSubscription,
    fill: true
  }, i18n.UPGRADE_BUTTON)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: i18n.UPGRADE_MESSAGE,
    src: _entity_paywall.default,
    size: "fullWidth"
  }))));
});
exports.Paywall = Paywall;
Paywall.displayName = 'Paywall';