"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.manageQuery = manageQuery;
exports.useQueryInspector = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function manageQuery(WrappedComponent) {
  var _WrappedComponent$dis;
  const ManageQuery = props => {
    const {
      deleteQuery,
      id,
      inspect = null,
      loading,
      refetch,
      setQuery,
      session
    } = props;
    useQueryInspector({
      deleteQuery,
      inspect,
      loading,
      queryId: id,
      refetch,
      session,
      setQuery
    });
    const otherProps = (0, _fp.omit)(['refetch', 'setQuery'], props);
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, otherProps);
  };
  ManageQuery.displayName = `ManageQuery (${(_WrappedComponent$dis = WrappedComponent === null || WrappedComponent === void 0 ? void 0 : WrappedComponent.displayName) !== null && _WrappedComponent$dis !== void 0 ? _WrappedComponent$dis : 'Unknown'})`;
  return ManageQuery;
}
const useQueryInspector = ({
  setQuery,
  deleteQuery,
  refetch,
  inspect,
  loading,
  queryId,
  session
}) => {
  (0, _react.useEffect)(() => {
    setQuery({
      id: queryId,
      inspect: inspect !== null && inspect !== void 0 ? inspect : null,
      loading,
      refetch,
      searchSessionId: session === null || session === void 0 ? void 0 : session.current.start()
    });
  }, [deleteQuery, setQuery, queryId, refetch, inspect, loading, session]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: queryId
        });
      }
    };
  }, [deleteQuery, queryId]);
};
exports.useQueryInspector = useQueryInspector;