"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverDescriptionComponent = exports.PopoverDescription = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PopoverDescriptionComponent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.components.mlPopup.anomalyDetectionDescription",
  defaultMessage: "Run any of the Machine Learning jobs below to prepare for creating detection rules that produce alerts for detected anomalies, and to view anomalous events throughout the Security application. We\u2019ve provided a collection of common detection jobs to get you started. If you wish to add your own custom ML jobs, create and add them to the \u201CSecurity\u201D group from the {machineLearning} application.",
  values: {
    machineLearning: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${(0, _kibana.useBasePath)()}/app/ml`,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.components.mlPopup.machineLearningLink",
      defaultMessage: "Machine Learning"
    }))
  }
}));
exports.PopoverDescriptionComponent = PopoverDescriptionComponent;
PopoverDescriptionComponent.displayName = 'PopoverDescriptionComponent';
const PopoverDescription = /*#__PURE__*/_react.default.memo(PopoverDescriptionComponent);
exports.PopoverDescription = PopoverDescription;
PopoverDescription.displayName = 'PopoverDescription';