"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlCapabilitiesProvider = exports.MlCapabilitiesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _empty_ml_capabilities = require("../../../../../common/machine_learning/empty_ml_capabilities");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _kibana = require("../../../lib/kibana");
var _use_get_ml_capabilities = require("../hooks/use_get_ml_capabilities");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyMlCapabilitiesProvider = {
  ..._empty_ml_capabilities.emptyMlCapabilities,
  capabilitiesFetched: false
};
const MlCapabilitiesContext = /*#__PURE__*/_react.default.createContext(emptyMlCapabilitiesProvider);
exports.MlCapabilitiesContext = MlCapabilitiesContext;
MlCapabilitiesContext.displayName = 'MlCapabilitiesContext';
const MlCapabilitiesProvider = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const [capabilities, setCapabilities] = (0, _react.useState)(emptyMlCapabilitiesProvider);
  const http = (0, _kibana.useHttp)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    start,
    result,
    error
  } = (0, _use_get_ml_capabilities.useGetMlCapabilities)();
  (0, _react.useEffect)(() => {
    start({
      http
    });
  }, [http, start]);
  (0, _react.useEffect)(() => {
    if (result) {
      setCapabilities({
        ...result,
        capabilitiesFetched: true
      });
    }
  }, [result]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.MACHINE_LEARNING_PERMISSIONS_FAILURE
      });
    }
  }, [addError, error]);
  return /*#__PURE__*/_react.default.createElement(MlCapabilitiesContext.Provider, {
    value: capabilities
  }, children);
});
exports.MlCapabilitiesProvider = MlCapabilitiesProvider;
MlCapabilitiesProvider.displayName = 'MlCapabilitiesProvider';