"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getAlertDetailsTabUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_alerts.getAlertDetailsTabUrl;
  }
});
Object.defineProperty(exports, "getAlertDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_alerts.getAlertDetailsUrl;
  }
});
Object.defineProperty(exports, "getCaseDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_case.getCaseDetailsUrl;
  }
});
Object.defineProperty(exports, "getCaseDetailsUrlWithCommentId", {
  enumerable: true,
  get: function () {
    return _redirect_to_case.getCaseDetailsUrlWithCommentId;
  }
});
Object.defineProperty(exports, "getCaseUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_case.getCaseUrl;
  }
});
Object.defineProperty(exports, "getConfigureCasesUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_case.getConfigureCasesUrl;
  }
});
Object.defineProperty(exports, "getCreateCaseUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_case.getCreateCaseUrl;
  }
});
Object.defineProperty(exports, "getDetectionEngineUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_detection_engine.getDetectionEngineUrl;
  }
});
Object.defineProperty(exports, "getHostDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_hosts.getHostDetailsUrl;
  }
});
Object.defineProperty(exports, "getHostsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_hosts.getHostsUrl;
  }
});
Object.defineProperty(exports, "getKubernetesDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_kubernetes.getKubernetesDetailsUrl;
  }
});
Object.defineProperty(exports, "getKubernetesUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_kubernetes.getKubernetesUrl;
  }
});
Object.defineProperty(exports, "getNetworkDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_network.getNetworkDetailsUrl;
  }
});
Object.defineProperty(exports, "getNetworkUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_network.getNetworkUrl;
  }
});
Object.defineProperty(exports, "getRuleDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_detection_engine.getRuleDetailsUrl;
  }
});
Object.defineProperty(exports, "getTabsOnHostDetailsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_hosts.getTabsOnHostDetailsUrl;
  }
});
Object.defineProperty(exports, "getTimelineTabsUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_timelines.getTimelineTabsUrl;
  }
});
Object.defineProperty(exports, "getTimelineUrl", {
  enumerable: true,
  get: function () {
    return _redirect_to_timelines.getTimelineUrl;
  }
});
exports.useGetSecuritySolutionUrl = exports.useFormatUrl = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _use_url_state_query_params = require("../navigation/use_url_state_query_params");
var _hooks = require("../../lib/kibana/hooks");
var _redirect_to_alerts = require("./redirect_to_alerts");
var _redirect_to_detection_engine = require("./redirect_to_detection_engine");
var _redirect_to_hosts = require("./redirect_to_hosts");
var _redirect_to_kubernetes = require("./redirect_to_kubernetes");
var _redirect_to_network = require("./redirect_to_network");
var _redirect_to_timelines = require("./redirect_to_timelines");
var _redirect_to_case = require("./redirect_to_case");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated `useFormatUrl` is deprecated. Alternatives:
 * - `SecuritySolutionLinkAnchor` -> Component with built-in Security link anchor
 * - `SecuritySolutionLinkButton` -> Component with built-in Security link button
 * - `withSecuritySolutionLink` -> HOC to create a custom Security link component.
 * - `useGetSecuritySolutionLinkProps` -> Hook to get `href` and `onClick` Security link props.
 * - `useGetSecuritySolutionUrl` -> Hook to get a Security formatted url.
 */
const useFormatUrl = page => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const queryParams = (0, _use_url_state_query_params.useUrlStateQueryParams)(page);
  const formatUrl = (0, _react.useCallback)((path, {
    absolute = false,
    skipSearch = false
  } = {}) => {
    const formattedPath = formatPath(path, queryParams, skipSearch);
    return getAppUrl({
      deepLinkId: page,
      path: formattedPath,
      absolute
    });
  }, [getAppUrl, page, queryParams]);
  return {
    formatUrl,
    search: queryParams
  };
};
exports.useFormatUrl = useFormatUrl;
const useGetSecuritySolutionUrl = () => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const getUrlStateQueryParams = (0, _use_url_state_query_params.useGetUrlStateQueryParams)();
  const getSecuritySolutionUrl = (0, _react.useCallback)(({
    deepLinkId,
    path = '',
    absolute = false,
    skipSearch = false
  }) => {
    const search = getUrlStateQueryParams(deepLinkId);
    const formattedPath = formatPath(path, search, skipSearch);
    return getAppUrl({
      deepLinkId,
      path: formattedPath,
      absolute
    });
  }, [getAppUrl, getUrlStateQueryParams]);
  return getSecuritySolutionUrl;
};
exports.useGetSecuritySolutionUrl = useGetSecuritySolutionUrl;
function formatPath(path, search, skipSearch) {
  const [urlPath, parameterPath] = path.split('?');
  const formattedPath = `${urlPath}${!skipSearch ? (0, _fp.isEmpty)(parameterPath) ? search : `?${parameterPath}${(0, _fp.isEmpty)(search) ? '' : `&${search}`}` : (0, _fp.isEmpty)(parameterPath) ? '' : `?${parameterPath}`}`;
  return formattedPath;
}