"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _utils = require("../utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _endpoint = _interopRequireDefault(require("../../images/endpoint1.svg"));
var _cloud = _interopRequireDefault(require("../../images/cloud1.svg"));
var _siem = _interopRequireDefault(require("../../images/siem1.svg"));
var _constants = require("../../../../common/constants");
var _kibana = require("../../lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const imgUrls = {
  cloud: _cloud.default,
  siem: _siem.default,
  endpoint: _endpoint.default
};
const StyledEuiCard = (0, _styledComponents.default)(_eui.EuiCard)`
  span.euiTitle {
    font-size: 36px;
    line-height: 100%;
  }
`;
const StyledEuiCardTop = (0, _styledComponents.default)(_eui.EuiCard)`
  span.euiTitle {
    font-size: 36px;
    line-height: 100%;
  }
  max-width: 600px;
  display: block;
  margin: 20px auto 0;
`;
const StyledEuiPageHeader = (0, _styledComponents.default)(_eui.EuiPageHeader)`
  h1 {
    font-size: 18px;
  }
`;
const StyledImgEuiCard = (0, _styledComponents.default)(_eui.EuiCard)`
  img {
    margin-top: 20px;
    max-width: 400px;
  }
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  background: ${({
  theme
}) => theme.eui.euiColorLightestShade};
  padding: 20px;
  margin: -12px !important;
`;
const LandingCards = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    http: {
      basePath: {
        prepend
      }
    },
    cloudExperiments
  } = (0, _kibana.useKibana)().services;
  const [addIntegrationsUrl, setAddIntegrationsUrl] = (0, _react.useState)(_constants.ADD_DATA_PATH);
  (0, _utils.useVariation)(cloudExperiments, 'security-solutions.add-integrations-url', _constants.ADD_DATA_PATH, setAddIntegrationsUrl);
  const href = (0, _react.useMemo)(() => prepend(addIntegrationsUrl), [prepend, addIntegrationsUrl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "siem-landing-page",
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiPageHeader, {
    pageTitle: i18n.SIEM_HEADER,
    iconType: "logoSecurity"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiCard, {
    display: "plain",
    description: i18n.SIEM_DESCRIPTION,
    textAlign: "left",
    title: i18n.SIEM_TITLE,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "add-integrations-header",
      href: href
    }, i18n.SIEM_CTA)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("iframe", {
    allowFullScreen: true,
    className: "vidyard_iframe",
    frameBorder: "0",
    height: "100%",
    referrerPolicy: "no-referrer",
    sandbox: "allow-scripts allow-same-origin",
    scrolling: "no",
    src: "//play.vidyard.com/K6kKDBbP9SpXife9s2tHNP.html?",
    title: i18n.SIEM_HEADER,
    width: "100%"
  })))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledImgEuiCard, {
    hasBorder: true,
    description: i18n.SIEM_CARD_DESCRIPTION,
    image: imgUrls.siem,
    textAlign: "center",
    title: i18n.SIEM_CARD_TITLE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledImgEuiCard, {
    hasBorder: true,
    description: i18n.ENDPOINT_DESCRIPTION,
    image: imgUrls.endpoint,
    textAlign: "center",
    title: i18n.ENDPOINT_TITLE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledImgEuiCard, {
    hasBorder: true,
    description: i18n.CLOUD_CARD_DESCRIPTION,
    image: imgUrls.cloud,
    textAlign: "center",
    title: i18n.CLOUD_CARD_TITLE
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(StyledEuiCardTop, {
    display: "plain",
    description: i18n.UNIFY_DESCRIPTION,
    paddingSize: "l",
    textAlign: "center",
    title: i18n.UNIFY_TITLE,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "add-integrations-footer",
      href: href
    }, i18n.SIEM_CTA)
  })));
});
exports.LandingCards = LandingCards;
LandingCards.displayName = 'LandingCards';