"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspect = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../store/inputs/constants");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInspect = ({
  inputId = _constants.InputsModelId.global,
  inspectIndex = 0,
  isDisabled,
  multiple = false,
  // If multiple = true we ignore the inspectIndex and pass all requests and responses to the inspect modal
  onClick,
  onCloseInspect,
  queryId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalQuery = _store.inputsSelectors.globalQueryByIdSelector();
  const getTimelineQuery = _store.inputsSelectors.timelineQueryByIdSelector();
  const {
    loading,
    inspect,
    selectedInspectIndex,
    isInspected
  } = (0, _use_selector.useDeepEqualSelector)(state => inputId === _constants.InputsModelId.global ? getGlobalQuery(state, queryId) : getTimelineQuery(state, queryId));
  const handleClick = (0, _react.useCallback)(() => {
    if (onClick) {
      onClick();
    }
    dispatch(_actions.inputsActions.setInspectionParameter({
      id: queryId,
      inputId,
      isInspected: true,
      selectedInspectIndex: inspectIndex
    }));
  }, [onClick, dispatch, queryId, inputId, inspectIndex]);
  const handleCloseModal = (0, _react.useCallback)(() => {
    if (onCloseInspect != null) {
      onCloseInspect();
    }
    dispatch(_actions.inputsActions.setInspectionParameter({
      id: queryId,
      inputId,
      isInspected: false,
      selectedInspectIndex: inspectIndex
    }));
  }, [onCloseInspect, dispatch, queryId, inputId, inspectIndex]);
  let request = null;
  let additionalRequests = null;
  if (inspect != null && inspect.dsl.length > 0) {
    if (multiple) {
      [request, ...additionalRequests] = inspect.dsl;
    } else {
      request = inspect.dsl[inspectIndex];
    }
  }
  let response = null;
  let additionalResponses = null;
  if (inspect != null && inspect.response.length > 0) {
    if (multiple) {
      [response, ...additionalResponses] = inspect.response;
    } else {
      response = inspect.response[inspectIndex];
    }
  }
  const isShowingModal = (0, _react.useMemo)(() => !loading && selectedInspectIndex === inspectIndex && isInspected, [inspectIndex, isInspected, loading, selectedInspectIndex]);
  const isButtonDisabled = (0, _react.useMemo)(() => loading || isDisabled || request == null || response == null || queryId == null, [isDisabled, loading, queryId, request, response]);
  return {
    additionalRequests,
    additionalResponses,
    handleClick,
    handleCloseModal,
    isButtonDisabled,
    isShowingModal,
    loading,
    request,
    response
  };
};
exports.useInspect = useInspect;