"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHoverActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _timeline = require("../../../timelines/components/timeline");
var _ = require(".");
var _draggable_wrapper = require("../drag_and_drop/draggable_wrapper");
var _helpers = require("../drag_and_drop/helpers");
var _shared = require("../events_viewer/shared");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const draggableContainsLinks = draggableElement => {
  var _draggableElement$que;
  const links = (_draggableElement$que = draggableElement === null || draggableElement === void 0 ? void 0 : draggableElement.querySelectorAll('.euiLink')) !== null && _draggableElement$que !== void 0 ? _draggableElement$que : [];
  return links.length > 0;
};
const useHoverActions = ({
  dataProvider,
  isAggregatable,
  fieldType,
  hideTopN,
  isDraggable,
  onFilterAdded,
  render,
  scopeId
}) => {
  const {
    timelineId: timelineIdFind
  } = (0, _react.useContext)(_timeline.TimelineContext);
  const {
    tableId: tableIdFind
  } = (0, _react.useContext)(_shared.TableContext);
  const containerRef = (0, _react.useRef)(null);
  const keyboardHandlerRef = (0, _react.useRef)(null);
  const [closePopOverTrigger, setClosePopOverTrigger] = (0, _react.useState)(false);
  const [hoverActionsOwnFocus, setHoverActionsOwnFocus] = (0, _react.useState)(false);
  const id = (0, _react.useMemo)(() => !scopeId ? timelineIdFind !== null && timelineIdFind !== void 0 ? timelineIdFind : tableIdFind : scopeId, [scopeId, tableIdFind, timelineIdFind]);
  const handleClosePopOverTrigger = (0, _react.useCallback)(() => {
    setClosePopOverTrigger(prevClosePopOverTrigger => !prevClosePopOverTrigger);
    setHoverActionsOwnFocus(prevHoverActionsOwnFocus => {
      if (prevHoverActionsOwnFocus) {
        setTimeout(() => {
          var _keyboardHandlerRef$c;
          (_keyboardHandlerRef$c = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c === void 0 ? void 0 : _keyboardHandlerRef$c.focus();
        }, 0);
      }
      return false; // always give up ownership
    });

    setTimeout(() => {
      setHoverActionsOwnFocus(false);
    }, 0); // invoked on the next tick, because we want to restore focus first
  }, [keyboardHandlerRef]);
  const {
    closeTopN,
    toggleTopN,
    isShowingTopN
  } = (0, _utils.useTopNPopOver)(handleClosePopOverTrigger);
  const values = (0, _react.useMemo)(() => {
    const val = dataProvider.queryMatch.value;
    if (typeof val === 'number' || typeof val === 'boolean') {
      return val.toString();
    }
    if (Array.isArray(val)) {
      return val.map(item => String(item));
    }
    return val;
  }, [dataProvider.queryMatch.value]);
  const hoverContent = (0, _react.useMemo)(() => {
    // display links as additional content in the hover menu to enable keyboard
    // navigation of links (when the draggable contains them):
    const additionalContent = hoverActionsOwnFocus && !isShowingTopN && draggableContainsLinks(containerRef.current) ? /*#__PURE__*/_react.default.createElement(_draggable_wrapper.ProviderContentWrapper, {
      "data-test-subj": `draggable-link-content-${dataProvider.queryMatch.field}`
    }, render(dataProvider, null, {
      isDragging: false,
      isDropAnimating: false
    })) : null;
    return /*#__PURE__*/_react.default.createElement(_.HoverActions, {
      additionalContent: additionalContent,
      closeTopN: closeTopN,
      closePopOver: handleClosePopOverTrigger,
      dataProvider: dataProvider,
      draggableId: isDraggable ? (0, _helpers.getDraggableId)(dataProvider.id) : undefined,
      field: dataProvider.queryMatch.field,
      isAggregatable: isAggregatable,
      fieldType: fieldType,
      hideTopN: hideTopN,
      isObjectArray: false,
      onFilterAdded: onFilterAdded,
      ownFocus: hoverActionsOwnFocus,
      showOwnFocus: false,
      showTopN: isShowingTopN,
      scopeId: id,
      toggleTopN: toggleTopN,
      values: values
    });
  }, [hoverActionsOwnFocus, isShowingTopN, dataProvider, render, closeTopN, handleClosePopOverTrigger, isDraggable, isAggregatable, fieldType, hideTopN, onFilterAdded, id, toggleTopN, values]);
  const setContainerRef = (0, _react.useCallback)(e => {
    containerRef.current = e;
  }, []);
  const onFocus = (0, _react.useCallback)(() => {
    if (!hoverActionsOwnFocus) {
      var _keyboardHandlerRef$c2;
      (_keyboardHandlerRef$c2 = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c2 === void 0 ? void 0 : _keyboardHandlerRef$c2.focus();
    }
  }, [hoverActionsOwnFocus, keyboardHandlerRef]);
  const onCloseRequested = (0, _react.useCallback)(() => {
    closeTopN();
    if (hoverActionsOwnFocus) {
      setHoverActionsOwnFocus(false);
      setTimeout(() => {
        onFocus(); // return focus to this draggable on the next tick, because we owned focus
      }, 0);
    }
  }, [onFocus, hoverActionsOwnFocus, closeTopN]);
  const openPopover = (0, _react.useCallback)(() => {
    setHoverActionsOwnFocus(true);
  }, []);
  return (0, _react.useMemo)(() => ({
    closePopOverTrigger,
    handleClosePopOverTrigger,
    hoverActionsOwnFocus,
    hoverContent,
    keyboardHandlerRef,
    onCloseRequested,
    onFocus,
    openPopover,
    setContainerRef,
    isShowingTopN
  }), [closePopOverTrigger, handleClosePopOverTrigger, hoverActionsOwnFocus, hoverContent, onCloseRequested, onFocus, openPopover, setContainerRef, isShowingTopN]);
};
exports.useHoverActions = useHoverActions;