"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SAVE = exports.EDIT_TITLE_ARIA = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVE = _i18n.i18n.translate('xpack.securitySolution.header.editableTitle.save', {
  defaultMessage: 'Save'
});
exports.SAVE = SAVE;
const CANCEL = _i18n.i18n.translate('xpack.securitySolution.header.editableTitle.cancel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const EDIT_TITLE_ARIA = title => _i18n.i18n.translate('xpack.securitySolution.header.editableTitle.editButtonAria', {
  values: {
    title
  },
  defaultMessage: 'You can edit {title} by clicking'
});
exports.EDIT_TITLE_ARIA = EDIT_TITLE_ARIA;