"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScoreData = exports.ONLY_FIRST_ITEM_PAGINATION = void 0;
var _react = require("react");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_score = require("../../../explore/containers/risk_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONLY_FIRST_ITEM_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
exports.ONLY_FIRST_ITEM_PAGINATION = ONLY_FIRST_ITEM_PAGINATION;
const useRiskScoreData = data => {
  const {
    hostName,
    userName
  } = (0, _helpers.useBasicDataFromDetailsData)(data);
  const hostNameFilterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const {
    data: hostRiskData,
    loading: hostRiskLoading,
    isLicenseValid: isHostLicenseValid,
    isModuleEnabled: isHostRiskModuleEnabled
  } = (0, _risk_score.useRiskScore)({
    filterQuery: hostNameFilterQuery,
    pagination: ONLY_FIRST_ITEM_PAGINATION,
    riskEntity: _search_strategy.RiskScoreEntity.host,
    skip: !hostNameFilterQuery
  });
  const hostRisk = (0, _react.useMemo)(() => ({
    loading: hostRiskLoading,
    isModuleEnabled: isHostRiskModuleEnabled,
    result: hostRiskData
  }), [hostRiskData, hostRiskLoading, isHostRiskModuleEnabled]);
  const userNameFilterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const {
    data: userRiskData,
    loading: userRiskLoading,
    isLicenseValid: isUserLicenseValid,
    isModuleEnabled: isUserRiskModuleEnabled
  } = (0, _risk_score.useRiskScore)({
    filterQuery: userNameFilterQuery,
    pagination: ONLY_FIRST_ITEM_PAGINATION,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: !userNameFilterQuery
  });
  const userRisk = (0, _react.useMemo)(() => ({
    loading: userRiskLoading,
    isModuleEnabled: isUserRiskModuleEnabled,
    result: userRiskData
  }), [userRiskLoading, isUserRiskModuleEnabled, userRiskData]);
  return {
    userRisk,
    hostRisk,
    isLicenseValid: isHostLicenseValid && isUserLicenseValid
  };
};
exports.useRiskScoreData = useRiskScoreData;