"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _store = require("../../../store");
var _constants = require("../../../store/inputs/constants");
var _inputs = require("../../../store/inputs");
var _actions = require("../../../../timelines/store/timeline/actions");
var _actions2 = require("../../../store/actions");
var _model = require("../../../store/sourcerer/model");
var _timeline = require("../../../../../common/types/timeline");
var _api = require("../../../../../common/types/timeline/api");
var _use_create_timeline = require("../../../../timelines/components/timeline/properties/use_create_timeline");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _use_selector = require("../../../hooks/use_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InvestigateInTimelineButton = ({
  asEmptyButton,
  children,
  dataProviders,
  filters,
  timeRange,
  keepDataView,
  ...rest
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getDataViewsSelector = (0, _react.useMemo)(() => _store.sourcererSelectors.getSourcererDataViewsSelector(), []);
  const {
    defaultDataView,
    signalIndexName
  } = (0, _use_selector.useDeepEqualSelector)(state => getDataViewsSelector(state));
  const hasTemplateProviders = dataProviders && dataProviders.find(provider => provider.type === 'template');
  const clearTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: hasTemplateProviders ? _api.TimelineType.template : _api.TimelineType.default
  });
  const configureAndOpenTimeline = (0, _react.useCallback)(() => {
    if (dataProviders || filters) {
      // Reset the current timeline
      if (timeRange) {
        clearTimeline({
          timeRange
        });
      } else {
        clearTimeline();
      }
      if (dataProviders) {
        // Update the timeline's providers to match the current prevalence field query
        dispatch((0, _actions.updateProviders)({
          id: _timeline.TimelineId.active,
          providers: dataProviders
        }));
      }
      // Use filters if more than a certain amount of ids for dom performance.
      if (filters) {
        dispatch((0, _actions.setFilters)({
          id: _timeline.TimelineId.active,
          filters
        }));
      }
      // Only show detection alerts
      // (This is required so the timeline event count matches the prevalence count)
      if (!keepDataView) {
        dispatch(_actions2.sourcererActions.setSelectedDataView({
          id: _model.SourcererScopeName.timeline,
          selectedDataViewId: defaultDataView.id,
          selectedPatterns: [signalIndexName || '']
        }));
      }
      // Unlock the time range from the global time range
      dispatch(_inputs.inputsActions.removeLinkTo([_constants.InputsModelId.timeline, _constants.InputsModelId.global]));
    }
  }, [dataProviders, clearTimeline, dispatch, defaultDataView.id, signalIndexName, filters, timeRange, keepDataView]);
  return asEmptyButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    onClick: configureAndOpenTimeline,
    flush: "right",
    size: "xs"
  }, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "aria-label": _translations.ACTION_INVESTIGATE_IN_TIMELINE,
    onClick: configureAndOpenTimeline
  }, rest), children);
};
exports.InvestigateInTimelineButton = InvestigateInTimelineButton;
InvestigateInTimelineButton.displayName = 'InvestigateInTimelineButton';