"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryView = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _summary_table = require("./table/summary_table");
var _summary_value_cell = require("./table/summary_value_cell");
var _prevalence_cell = require("./table/prevalence_cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseColumns = [{
  field: 'title',
  truncateText: false,
  name: i18n.HIGHLIGHTED_FIELDS_FIELD,
  textOnly: true
}, {
  field: 'description',
  truncateText: false,
  render: _summary_value_cell.SummaryValueCell,
  name: i18n.HIGHLIGHTED_FIELDS_VALUE
}];
const allColumns = [...baseColumns, {
  field: 'description',
  truncateText: true,
  render: _prevalence_cell.PrevalenceCellRenderer,
  name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "iInCircle",
    color: "subdued",
    title: i18n.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE,
    content: /*#__PURE__*/_react.default.createElement("span", null, i18n.HIGHLIGHTED_FIELDS_ALERT_PREVALENCE_TOOLTIP)
  })),
  align: 'right',
  width: '130px'
}];
const rowProps = {
  // Class name for each row. On hover of a row, all actions for that row will be shown.
  className: 'flyoutTableHoverActions'
};
const SummaryViewComponent = ({
  goToTable,
  rows,
  title,
  isReadOnly
}) => {
  const columns = isReadOnly ? baseColumns : allColumns;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: goToTable,
    "data-test-subj": "summary-view-go-to-table-link"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, i18n.VIEW_ALL_FIELDS)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_summary_table.SummaryTable, {
    "data-test-subj": "summary-view",
    items: rows,
    columns: columns,
    rowProps: rowProps,
    compressed: true
  }));
};
const SummaryView = /*#__PURE__*/_react.default.memo(SummaryViewComponent);
exports.SummaryView = SummaryView;