"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DroppableWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _reactBeautifulDnd = require("react-beautiful-dnd");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReactDndDropTarget = _styledComponents.default.div`
  transition: background-color 0.7s ease;
  width: 100%;
  height: ${({
  height
}) => height};
  .flyout-overlay {
    .euiPanel {
      background-color: ${props => props.theme.eui.euiFormBackgroundColor};
    }
  }
  ${props => props.isDraggingOver ? `
    .drop-and-provider-timeline {
      &:hover {
        background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.3)};
      }
    }
    .drop-and-provider-timeline:hover {
        background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.3)};
    }
  > div.timeline-drop-area-empty {
     color: ${props.theme.eui.euiColorSuccess};
     background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.2)};

     & .timeline-drop-area-empty__text {
      color: ${props.theme.eui.euiColorSuccess};
     }
  }
  > div.timeline-drop-area {
    background-color: ${(0, _polished.rgba)(props.theme.eui.euiColorSuccess, 0.2)};
    .provider-item-filter-container div:first-child{
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      transform: none !important;
    }
    .drop-and-provider-timeline {
      display: block !important;
      + div {
        display: none;
      }
    }

    & .euiFormHelpText {
      color: ${props.theme.eui.euiColorSuccess};
    }
  }
  .flyout-overlay {
    .euiPanel {
      background-color: ${props.theme.eui.euiColorLightShade};
    }
    + div {
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      display: none !important;
    }
  }
  ` : ''}
  > div.timeline-drop-area {
    .drop-and-provider-timeline {
      display: none;
    }
    & + div {
      /* Override dragNdrop beautiful so we do not have our droppable moving around for no good reason */
      display: none !important;
    }
  }
`;
ReactDndDropTarget.displayName = 'ReactDndDropTarget';
const DroppableWrapper = /*#__PURE__*/_react.default.memo(({
  children = null,
  droppableId,
  height = '100%',
  isDropDisabled = false,
  type,
  render = null,
  renderClone
}) => {
  const DroppableContent = (0, _react.useCallback)((provided, snapshot) => /*#__PURE__*/_react.default.createElement(ReactDndDropTarget, (0, _extends2.default)({
    height: height,
    ref: provided.innerRef
  }, provided.droppableProps, {
    isDraggingOver: snapshot.isDraggingOver
  }), render == null ? children : render({
    isDraggingOver: snapshot.isDraggingOver
  }), provided.placeholder), [children, height, render]);
  return /*#__PURE__*/_react.default.createElement(_reactBeautifulDnd.Droppable, {
    isDropDisabled: isDropDisabled,
    droppableId: droppableId,
    direction: 'horizontal',
    type: type,
    renderClone: renderClone
  }, DroppableContent);
});
exports.DroppableWrapper = DroppableWrapper;
DroppableWrapper.displayName = 'DroppableWrapper';