"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDraggableKeyboardWrapper = void 0;
var _react = require("react");
var _kibana = require("../../../lib/kibana");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDraggableKeyboardWrapper = ({
  closePopover,
  draggableId,
  fieldName,
  keyboardHandlerRef,
  openPopover
}) => {
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const useAddToTimeline = timelines.getUseAddToTimeline();
  const {
    beginDrag,
    cancelDrag,
    dragToLocation,
    endDrag,
    hasDraggableLock
  } = useAddToTimeline({
    draggableId,
    fieldName
  });
  const [dragActions, setDragActions] = (0, _react.useState)(null);
  const cancelDragActions = (0, _react.useCallback)(() => {
    setDragActions(prevDragAction => {
      if (prevDragAction) {
        cancelDrag(prevDragAction);
        return null;
      }
      return null;
    });
  }, [cancelDrag]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    const draggableElement = document.querySelector(`[data-rbd-drag-handle-draggable-id="${draggableId}"]`);
    if (draggableElement) {
      var _keyboardHandlerRef$c;
      if (hasDraggableLock() || !hasDraggableLock() && keyboardEvent.key === ' ') {
        keyboardEvent.preventDefault();
        keyboardEvent.stopPropagation();
      }
      (0, _helpers.draggableKeyDownHandler)({
        beginDrag,
        cancelDragActions,
        closePopover,
        dragActions,
        draggableElement,
        dragToLocation,
        endDrag,
        keyboardEvent,
        openPopover,
        setDragActions
      });
      (_keyboardHandlerRef$c = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c === void 0 ? void 0 : _keyboardHandlerRef$c.focus(); // to handle future key presses
    }
  }, [beginDrag, cancelDragActions, closePopover, dragActions, draggableId, dragToLocation, endDrag, hasDraggableLock, keyboardHandlerRef, openPopover, setDragActions]);
  const memoizedReturn = (0, _react.useMemo)(() => ({
    onBlur: cancelDragActions,
    onKeyDown
  }), [cancelDragActions, onKeyDown]);
  return memoizedReturn;
};
exports.useDraggableKeyboardWrapper = useDraggableKeyboardWrapper;