"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledEuiFlexItem = exports.DonutTextWrapper = exports.DonutChartWrapper = exports.DonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common = require("./common");
var _draggable_legend = require("./draggable_legend");
var _donutchart_empty = require("./donutchart_empty");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const donutTheme = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    idealFontSizeJump: 1.1,
    outerSizeRatio: 1,
    emptySizeRatio: 0.8,
    circlePadding: 4
  }
};
/* Make this position absolute in order to overlap the text onto the donut */
const DonutTextWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  top: ${({
  $isChartEmbeddablesEnabled,
  $dataExists
}) => $isChartEmbeddablesEnabled && !$dataExists ? `66%` : `34%;`};
  width: 100%;
  max-width: 77px;
  position: absolute;
  z-index: 1;

  ${({
  className,
  $donutTextWrapperStyles
}) => className && $donutTextWrapperStyles ? `&.${className} {${$donutTextWrapperStyles}}` : ''}
`;
exports.DonutTextWrapper = DonutTextWrapper;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  position: relative;
  align-items: center;
`;
exports.StyledEuiFlexItem = StyledEuiFlexItem;
const DonutChartWrapperComponent = ({
  children,
  dataExists,
  donutTextWrapperClassName,
  donutTextWrapperStyles,
  isChartEmbeddablesEnabled,
  label,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const emptyLabelStyle = (0, _react.useMemo)(() => ({
    color: euiTheme.colors.disabled
  }), [euiTheme.colors.disabled]);
  const className = isChartEmbeddablesEnabled ? undefined : 'eui-textTruncate';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    responsive: false,
    gutterSize: "l",
    "data-test-subj": "donut-chart"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: isChartEmbeddablesEnabled
  }, /*#__PURE__*/_react.default.createElement(DonutTextWrapper, {
    $dataExists: dataExists,
    $donutTextWrapperStyles: donutTextWrapperStyles,
    $isChartEmbeddablesEnabled: isChartEmbeddablesEnabled,
    alignItems: "center",
    className: donutTextWrapperClassName,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, title), label && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: className,
    size: "s",
    style: dataExists ? undefined : emptyLabelStyle
  }, label)))), children));
};
const DonutChartWrapper = /*#__PURE__*/_react.default.memo(DonutChartWrapperComponent);
exports.DonutChartWrapper = DonutChartWrapper;
const DonutChart = ({
  data,
  fillColor,
  height = 90,
  label,
  legendItems,
  onPartitionClick,
  title,
  totalCount
}) => {
  const {
    baseTheme,
    theme
  } = (0, _common.useThemes)();
  const onElementClicked = (0, _react.useCallback)(event => {
    if (onPartitionClick) {
      var _flattened$;
      const flattened = event.flat(2);
      const level = flattened.length > 0 && 'groupByRollup' in flattened[0] && ((_flattened$ = flattened[0]) === null || _flattened$ === void 0 ? void 0 : _flattened$.groupByRollup) != null ? `${flattened[0].groupByRollup}` : '';
      if (!(0, _lodash.isEmpty)(level.trim())) {
        onPartitionClick(level.toLowerCase());
      }
    }
  }, [onPartitionClick]);
  return /*#__PURE__*/_react.default.createElement(DonutChartWrapper, {
    dataExists: data != null && data.length > 0,
    label: label,
    title: title,
    isChartEmbeddablesEnabled: false
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, data == null || totalCount == null || totalCount === 0 ? /*#__PURE__*/_react.default.createElement(_donutchart_empty.DonutChartEmpty, {
    size: height
  }) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: height
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [donutTheme, theme],
    baseTheme: baseTheme,
    onElementClick: onElementClicked
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "donut-chart",
    data: data,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.value,
    valueFormatter: d => `${(0, _charts.defaultPartitionValueFormatter)(d)}`,
    layers: [{
      groupByRollup: d => {
        var _d$label;
        return (_d$label = d.label) !== null && _d$label !== void 0 ? _d$label : d.key;
      },
      nodeLabel: d => d,
      shape: {
        fillColor
      }
    }]
  })), legendItems && (legendItems === null || legendItems === void 0 ? void 0 : legendItems.length) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    legendItems: legendItems,
    height: height
  }))));
};
exports.DonutChart = DonutChart;