"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RISK_LABEL = exports.NO_DATA_REASON_LABEL = exports.NO_DATA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_DATA_LABEL = _i18n.i18n.translate('xpack.securitySolution.components.alertsTreemap.noDataLabel', {
  defaultMessage: 'No data to display'
});
exports.NO_DATA_LABEL = NO_DATA_LABEL;
const NO_DATA_REASON_LABEL = stackByField1 => _i18n.i18n.translate('xpack.securitySolution.components.alertsTreemap.noDataReasonLabel', {
  values: {
    stackByField1
  },
  defaultMessage: 'The {stackByField1} field was not present in any groups'
});
exports.NO_DATA_REASON_LABEL = NO_DATA_REASON_LABEL;
const RISK_LABEL = riskScore => _i18n.i18n.translate('xpack.securitySolution.components.alertsTreemap.riskLabel', {
  values: {
    riskScore
  },
  defaultMessage: '(Risk {riskScore})'
});
exports.RISK_LABEL = RISK_LABEL;