"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiSelectPopover = /*#__PURE__*/_react.default.memo(({
  allItems,
  selectedItems,
  title,
  onSelectedItemsChange
}) => {
  const [isItemPopoverOpen, setIsItemPopoverOpen] = (0, _react.useState)(false);
  const onChange = (0, _react.useCallback)(item => onSelectedItemsChange(getUpdatedSelectedItems(item, selectedItems)), [selectedItems, onSelectedItemsChange]);
  const itemList = (0, _react.useMemo)(() => {
    return allItems.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: selectedItems.includes(item) ? 'on' : undefined,
      key: `${index}-${item}`,
      onClick: () => onChange(item),
      title: item
    }, item));
  }, [allItems, selectedItems, onChange]);
  const togglePopover = (0, _react.useCallback)(toState => {
    setIsItemPopoverOpen(s => toState ? toState : !s);
  }, [setIsItemPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      grow: false,
      "data-test-subj": 'multiselect-popover-button',
      iconType: "arrowDown",
      onClick: () => togglePopover(),
      numFilters: allItems.length,
      isSelected: isItemPopoverOpen,
      hasActiveFilters: selectedItems.length > 0,
      numActiveFilters: selectedItems.length
    }, title)),
    isOpen: isItemPopoverOpen,
    closePopover: () => togglePopover(false),
    panelPaddingSize: "none"
  }, itemList);
});
exports.MultiSelectPopover = MultiSelectPopover;
MultiSelectPopover.displayName = 'MultiSelectPopover';
const getUpdatedSelectedItems = (item, selectedItems) => {
  const selectedGroupIndex = selectedItems.indexOf(item);
  const updatedSelectedItems = [...selectedItems];
  if (selectedGroupIndex >= 0) {
    updatedSelectedItems.splice(selectedGroupIndex, 1);
  } else {
    updatedSelectedItems.push(item);
  }
  return updatedSelectedItems;
};