"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROMPT_CONTEXT_EVENT_CATEGORY = exports.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = exports.PROMPT_CONTEXT_ALERT_CATEGORY = exports.PROMPT_CONTEXTS = exports.DATA_QUALITY_DASHBOARD_CATEGORY = void 0;
var i18nDataQuality = _interopRequireWildcard(require("@kbn/ecs-data-quality-dashboard"));
var i18n = _interopRequireWildcard(require("./translations"));
var i18nDetections = _interopRequireWildcard(require("../../../detections/pages/detection_engine/rules/translations"));
var i18nEventDetails = _interopRequireWildcard(require("../../../common/components/event_details/translations"));
var i18nUserPrompts = _interopRequireWildcard(require("../prompts/user/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROMPT_CONTEXT_ALERT_CATEGORY = 'alert';
exports.PROMPT_CONTEXT_ALERT_CATEGORY = PROMPT_CONTEXT_ALERT_CATEGORY;
const PROMPT_CONTEXT_EVENT_CATEGORY = 'event';
exports.PROMPT_CONTEXT_EVENT_CATEGORY = PROMPT_CONTEXT_EVENT_CATEGORY;
const PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = 'detection-rules';
exports.PROMPT_CONTEXT_DETECTION_RULES_CATEGORY = PROMPT_CONTEXT_DETECTION_RULES_CATEGORY;
const DATA_QUALITY_DASHBOARD_CATEGORY = 'data-quality-dashboard';

/**
 * Global list of PromptContexts intended to be used throughout Security Solution.
 * Useful if wanting to see all available PromptContexts in one place, or if needing
 * a unique set of categories to reference since the PromptContexts available on
 * useAssistantContext are dynamic (not globally registered).
 */
exports.DATA_QUALITY_DASHBOARD_CATEGORY = DATA_QUALITY_DASHBOARD_CATEGORY;
const PROMPT_CONTEXTS = {
  /**
   * Alert summary view context, made available on the alert details flyout
   */
  [PROMPT_CONTEXT_ALERT_CATEGORY]: {
    category: PROMPT_CONTEXT_ALERT_CATEGORY,
    suggestedUserPrompt: i18nUserPrompts.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE_NON_I18N,
    description: i18nEventDetails.ALERT_SUMMARY_CONTEXT_DESCRIPTION(i18n.VIEW),
    tooltip: i18nEventDetails.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP
  },
  /**
   * Event summary view context, made available from Timeline events
   */
  [PROMPT_CONTEXT_EVENT_CATEGORY]: {
    category: PROMPT_CONTEXT_EVENT_CATEGORY,
    suggestedUserPrompt: i18nUserPrompts.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE_NON_I18N,
    description: i18nEventDetails.EVENT_SUMMARY_CONTEXT_DESCRIPTION(i18n.VIEW),
    tooltip: i18nEventDetails.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP
  },
  /**
   * Data Quality dashboard context, made available on the Data Quality dashboard
   */
  [DATA_QUALITY_DASHBOARD_CATEGORY]: {
    category: DATA_QUALITY_DASHBOARD_CATEGORY,
    suggestedUserPrompt: i18nDataQuality.DATA_QUALITY_SUGGESTED_USER_PROMPT,
    description: i18nDataQuality.DATA_QUALITY_PROMPT_CONTEXT_PILL(i18n.INDEX),
    tooltip: i18nDataQuality.DATA_QUALITY_PROMPT_CONTEXT_PILL_TOOLTIP
  },
  /**
   * Detection Rules context, made available on the Rule Management page when rules are selected
   */
  [PROMPT_CONTEXT_DETECTION_RULES_CATEGORY]: {
    category: PROMPT_CONTEXT_DETECTION_RULES_CATEGORY,
    suggestedUserPrompt: i18nDetections.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS,
    description: i18nDetections.RULE_MANAGEMENT_CONTEXT_DESCRIPTION,
    tooltip: i18nDetections.RULE_MANAGEMENT_CONTEXT_TOOLTIP
  }
};
exports.PROMPT_CONTEXTS = PROMPT_CONTEXTS;