"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE_SECURITY_CONVERSATIONS = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _translations = require("@kbn/ecs-data-quality-dashboard/impl/data_quality/data_quality_panel/tabs/summary_tab/callout_summary/translations");
var _translations2 = require("../../../detections/pages/detection_engine/rules/translations");
var _translations3 = require("../../../common/components/event_details/translations");
var _translations4 = require("../../comment_actions/translations");
var _translations5 = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BASE_SECURITY_CONVERSATIONS = {
  [_translations3.ALERT_SUMMARY_CONVERSATION_ID]: {
    id: _translations3.ALERT_SUMMARY_CONVERSATION_ID,
    isDefault: true,
    messages: [],
    apiConfig: {}
  },
  [_translations.DATA_QUALITY_DASHBOARD_CONVERSATION_ID]: {
    id: _translations.DATA_QUALITY_DASHBOARD_CONVERSATION_ID,
    isDefault: true,
    messages: [],
    apiConfig: {}
  },
  [_translations2.DETECTION_RULES_CONVERSATION_ID]: {
    id: _translations2.DETECTION_RULES_CONVERSATION_ID,
    isDefault: true,
    messages: [],
    apiConfig: {}
  },
  [_translations3.EVENT_SUMMARY_CONVERSATION_ID]: {
    id: _translations3.EVENT_SUMMARY_CONVERSATION_ID,
    isDefault: true,
    messages: [],
    apiConfig: {}
  },
  [_translations5.TIMELINE_CONVERSATION_TITLE]: {
    excludeFromLastConversationStorage: true,
    id: _translations5.TIMELINE_CONVERSATION_TITLE,
    isDefault: true,
    messages: [],
    apiConfig: {}
  },
  [_elasticAssistant.WELCOME_CONVERSATION_TITLE]: {
    id: _elasticAssistant.WELCOME_CONVERSATION_TITLE,
    isDefault: true,
    theme: {
      title: _elasticAssistant.ELASTIC_AI_ASSISTANT_TITLE,
      titleIcon: 'logoSecurity',
      assistant: {
        name: _translations4.ELASTIC_AI_ASSISTANT,
        icon: 'logoSecurity'
      },
      system: {
        icon: 'logoElastic'
      },
      user: {}
    },
    messages: [],
    apiConfig: {}
  }
};
exports.BASE_SECURITY_CONVERSATIONS = BASE_SECURITY_CONVERSATIONS;