"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactRedux = require("react-redux");
var _constants = require("../../common/constants");
var _route_capture = require("../common/components/endpoint/route_capture");
var _kibana = require("../common/lib/kibana");
var _manage_spy_routes = require("../common/utils/route/manage_spy_routes");
var _ = require("./404");
var _home = require("./home");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageRouterComponent = ({
  children,
  history,
  onAppLeave,
  setHeaderActionMenu
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const CasesContext = cases.ui.getCasesContext();
  const userCasesPermissions = (0, _kibana.useGetUserCasesPermissions)();
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    return () => {
      // When app is dismounted via a non-router method (ex. using Kibana's `services.application.navigateToApp()`)
      // ensure that one last `userChangedUrl` store action is dispatched, which will help trigger state reset logic
      dispatch({
        type: 'userChangedUrl',
        payload: {
          pathname: '',
          search: '',
          hash: ''
        }
      });
    };
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_manage_spy_routes.ManageRoutesSpy, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_route_capture.RouteCapture, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }, /*#__PURE__*/_react.default.createElement(_home.HomePage, {
    setHeaderActionMenu: setHeaderActionMenu
  }, children))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_.NotFoundPage, null))))));
};
const PageRouter = /*#__PURE__*/(0, _react.memo)(PageRouterComponent);
exports.PageRouter = PageRouter;