"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactReversePortal = require("react-reverse-portal");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _utils = require("../../../common/components/utils");
var _ml_popover = require("../../../common/components/ml_popover/ml_popover");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _helpers = require("../../../helpers");
var _sourcerer = require("../../../common/components/sourcerer");
var _timeline = require("../../../../common/types/timeline");
var _defaults = require("../../../timelines/store/timeline/defaults");
var _timeline2 = require("../../../timelines/store/timeline");
var _use_selector = require("../../../common/hooks/use_selector");
var _sourcerer2 = require("../../../common/containers/sourcerer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_ADD_DATA = _i18n.i18n.translate('xpack.securitySolution.globalHeader.buttonAddData', {
  defaultMessage: 'Add integrations'
});

/**
 * This component uses the reverse portal to add the Add Data and ML job settings buttons on the
 * right hand side of the Kibana global header
 */
const GlobalHeader = /*#__PURE__*/_react.default.memo(({
  setHeaderActionMenu
}) => {
  const portalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  const {
    theme,
    http: {
      basePath: {
        prepend
      }
    },
    cloudExperiments
  } = (0, _kibana.useKibana)().services;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, _timeline.TimelineId.active)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).show;
  });
  const sourcererScope = (0, _sourcerer2.getScopeFromPath)(pathname);
  const showSourcerer = (0, _sourcerer2.showSourcererByPath)(pathname);
  const integrationsUrl = (0, _helpers.isThreatIntelligencePath)(pathname) ? _constants.ADD_THREAT_INTELLIGENCE_DATA_PATH : _constants.ADD_DATA_PATH;
  const [addIntegrationsUrl, setAddIntegrationsUrl] = (0, _react.useState)(integrationsUrl);
  (0, _utils.useVariation)(cloudExperiments, 'security-solutions.add-integrations-url', integrationsUrl, setAddIntegrationsUrl);
  const href = (0, _react.useMemo)(() => prepend(addIntegrationsUrl), [prepend, addIntegrationsUrl]);
  (0, _react.useEffect)(() => {
    setHeaderActionMenu(element => {
      const mount = (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: portalNode
      }), {
        theme$: theme.theme$
      });
      return mount(element);
    });
    return () => {
      portalNode.unmount();
      setHeaderActionMenu(undefined);
    };
  }, [portalNode, setHeaderActionMenu, theme.theme$]);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right"
  }, (0, _helpers.isDetectionsPath)(pathname) && /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_ml_popover.MlPopover, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    "data-test-subj": "add-data",
    href: href,
    iconType: "indexOpen"
  }, BUTTON_ADD_DATA), showSourcerer && !showTimeline && /*#__PURE__*/_react.default.createElement(_sourcerer.Sourcerer, {
    scope: sourcererScope,
    "data-test-subj": "sourcerer"
  })))));
});
exports.GlobalHeader = GlobalHeader;
GlobalHeader.displayName = 'GlobalHeader';