"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUIActions = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _filter = require("./filter");
var _add_to_timeline = require("./add_to_timeline");
var _show_top_n = require("./show_top_n");
var _copy_to_clipboard = require("./copy_to_clipboard");
var _toggle_column = require("./toggle_column");
var _constants = require("./constants");
var _telemetry = require("./telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUIActions = (store, history, services) => {
  registerLensActions(store, services);
  registerCellActions(store, history, services);
};
exports.registerUIActions = registerUIActions;
const registerLensActions = (store, services) => {
  const {
    uiActions
  } = services;
  const addToTimelineAction = (0, _add_to_timeline.createAddToTimelineLensAction)({
    store,
    order: 1
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, addToTimelineAction);
  const copyToClipboardAction = (0, _copy_to_clipboard.createCopyToClipboardLensAction)({
    order: 2
  });
  uiActions.addTriggerAction(_public.CELL_VALUE_TRIGGER, copyToClipboardAction);
};
const registerCellActions = (store, history, services) => {
  const cellActions = {
    filterIn: (0, _filter.createFilterInCellActionFactory)({
      store,
      services
    }),
    filterOut: (0, _filter.createFilterOutCellActionFactory)({
      store,
      services
    }),
    addToTimeline: (0, _add_to_timeline.createAddToTimelineCellActionFactory)({
      store,
      services
    }),
    investigateInNewTimeline: (0, _add_to_timeline.createInvestigateInNewTimelineCellActionFactory)({
      store,
      services
    }),
    showTopN: (0, _show_top_n.createShowTopNCellActionFactory)({
      store,
      history,
      services
    }),
    copyToClipboard: (0, _copy_to_clipboard.createCopyToClipboardCellActionFactory)({
      services
    }),
    toggleColumn: (0, _toggle_column.createToggleColumnCellActionFactory)({
      store
    })
  };
  registerCellActionsTrigger({
    triggerId: _constants.SecurityCellActionsTrigger.DEFAULT,
    cellActions,
    actionsOrder: ['filterIn', 'filterOut', 'addToTimeline', 'showTopN', 'copyToClipboard'],
    services
  });
  registerCellActionsTrigger({
    triggerId: _constants.SecurityCellActionsTrigger.DETAILS_FLYOUT,
    cellActions,
    actionsOrder: ['filterIn', 'filterOut', 'addToTimeline', 'toggleColumn', 'showTopN', 'copyToClipboard'],
    services
  });
  registerCellActionsTrigger({
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    cellActions,
    actionsOrder: ['investigateInNewTimeline'],
    services
  });
};
const registerCellActionsTrigger = ({
  triggerId,
  cellActions,
  actionsOrder,
  services
}) => {
  const {
    uiActions
  } = services;
  uiActions.registerTrigger({
    id: triggerId
  });
  actionsOrder.forEach((actionName, order) => {
    const actionFactory = cellActions[actionName];
    if (actionFactory) {
      const action = actionFactory({
        id: `${triggerId}-${actionName}`,
        order
      });
      uiActions.addTriggerAction(triggerId, (0, _telemetry.enhanceActionWithTelemetry)(action, services));
    }
  });
};