"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleToAlertResponseAction = exports.transformRuleToAlertAction = exports.transformNormalizedRuleToAlertAction = exports.transformAlertToRuleResponseAction = exports.transformAlertToRuleAction = exports.transformAlertToNormalizedRuleAction = void 0;
var _schemas = require("./rule_response_actions/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformRuleToAlertAction = ({
  group,
  id,
  action_type_id: actionTypeId,
  params,
  uuid,
  frequency,
  alerts_filter: alertsFilter
}) => ({
  group,
  id,
  params,
  actionTypeId,
  ...(alertsFilter && {
    alertsFilter
  }),
  ...(uuid && {
    uuid
  }),
  ...(frequency && {
    frequency
  })
});
exports.transformRuleToAlertAction = transformRuleToAlertAction;
const transformAlertToRuleAction = ({
  group,
  id,
  actionTypeId,
  params,
  uuid,
  frequency,
  alertsFilter
}) => ({
  group,
  id,
  params,
  action_type_id: actionTypeId,
  ...(alertsFilter && {
    alerts_filter: alertsFilter
  }),
  ...(uuid && {
    uuid
  }),
  ...(frequency && {
    frequency
  })
});
exports.transformAlertToRuleAction = transformAlertToRuleAction;
const transformNormalizedRuleToAlertAction = ({
  group,
  id,
  params,
  frequency,
  alerts_filter: alertsFilter
}) => ({
  group,
  id,
  params,
  ...(alertsFilter && {
    alertsFilter
  }),
  ...(frequency && {
    frequency
  })
});
exports.transformNormalizedRuleToAlertAction = transformNormalizedRuleToAlertAction;
const transformAlertToNormalizedRuleAction = ({
  group,
  id,
  params,
  frequency,
  alertsFilter
}) => ({
  group,
  id,
  params,
  ...(alertsFilter && {
    alerts_filter: alertsFilter
  }),
  ...(frequency && {
    frequency
  })
});
exports.transformAlertToNormalizedRuleAction = transformAlertToNormalizedRuleAction;
const transformRuleToAlertResponseAction = ({
  action_type_id: actionTypeId,
  params
}) => {
  if (actionTypeId === _schemas.RESPONSE_ACTION_TYPES.OSQUERY) {
    const {
      saved_query_id: savedQueryId,
      ecs_mapping: ecsMapping,
      pack_id: packId,
      ...rest
    } = params;
    return {
      params: {
        ...rest,
        savedQueryId,
        ecsMapping,
        packId
      },
      actionTypeId
    };
  }
  return {
    params,
    actionTypeId
  };
};
exports.transformRuleToAlertResponseAction = transformRuleToAlertResponseAction;
const transformAlertToRuleResponseAction = ({
  actionTypeId,
  params
}) => {
  if (actionTypeId === _schemas.RESPONSE_ACTION_TYPES.OSQUERY) {
    const {
      savedQueryId,
      ecsMapping,
      packId,
      ...rest
    } = params;
    return {
      params: {
        ...rest,
        saved_query_id: savedQueryId,
        ecs_mapping: ecsMapping,
        pack_id: packId
      },
      action_type_id: actionTypeId
    };
  }
  return {
    params,
    action_type_id: actionTypeId
  };
};
exports.transformAlertToRuleResponseAction = transformAlertToRuleResponseAction;