"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDelete = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConfirmDelete extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.setState({
        deleteInProgress: true
      }, () => {
        this.deleteRoles();
      });
    });
    (0, _defineProperty2.default)(this, "deleteRoles", async () => {
      const {
        rolesToDelete,
        callback,
        rolesAPIClient,
        notifications
      } = this.props;
      const errors = [];
      const deleteOperations = rolesToDelete.map(roleName => {
        const deleteRoleTask = async () => {
          try {
            await rolesAPIClient.deleteRole(roleName);
            notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleSuccessfullyDeletedNotificationMessage', {
              defaultMessage: 'Deleted role {roleName}',
              values: {
                roleName
              }
            }));
          } catch (e) {
            errors.push(roleName);
            notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleDeletingErrorNotificationMessage', {
              defaultMessage: 'Error deleting role {roleName}',
              values: {
                roleName
              }
            }));
          }
        };
        return deleteRoleTask();
      });
      await Promise.all(deleteOperations);
      callback(rolesToDelete, errors);
    });
    this.state = {
      deleteInProgress: false
    };
  }
  render() {
    const {
      rolesToDelete
    } = this.props;
    const moreThanOne = rolesToDelete.length > 1;
    const title = _i18n.i18n.translate('xpack.security.management.roles.deleteRoleTitle', {
      defaultMessage: 'Delete role{value, plural, one {{roleName}} other {s}}',
      values: {
        value: rolesToDelete.length,
        roleName: ` ${rolesToDelete[0]}`
      }
    });

    // This is largely the same as the built-in EuiConfirmModal component, but we needed the ability
    // to disable the buttons since this could be a long-running operation

    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.props.onCancel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      "data-test-subj": "confirmModalTitleText"
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, moreThanOne ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.removingRolesDescription",
      defaultMessage: "You are about to delete these roles:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, rolesToDelete.map(roleName => /*#__PURE__*/_react.default.createElement("li", {
      key: roleName
    }, roleName)))) : null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.deletingRolesWarningMessage",
      defaultMessage: "You can't undo this operation."
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "confirmModalCancelButton",
      onClick: this.props.onCancel,
      isDisabled: this.state.deleteInProgress
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.cancelButtonLabel",
      defaultMessage: "Cancel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "confirmModalConfirmButton",
      onClick: this.onConfirmDelete,
      fill: true,
      color: 'danger',
      isLoading: this.state.deleteInProgress
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.deleteButtonLabel",
      defaultMessage: "Delete"
    }))));
  }
}
exports.ConfirmDelete = ConfirmDelete;