"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPrivileges = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _privilege_utils = require("../edit_role/privilege_utils");
var _kibana_privilege = require("./kibana_privilege");
var _privilege_collection = require("./privilege_collection");
var _secured_feature = require("./secured_feature");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toBasePrivilege(entry) {
  const [privilegeId, actions] = entry;
  return [privilegeId, new _kibana_privilege.KibanaPrivilege(privilegeId, actions)];
}
function recordsToBasePrivilegeMap(record) {
  return new Map(Object.entries(record).map(entry => toBasePrivilege(entry)));
}
class KibanaPrivileges {
  constructor(rawKibanaPrivileges, features) {
    (0, _defineProperty2.default)(this, "global", void 0);
    (0, _defineProperty2.default)(this, "spaces", void 0);
    (0, _defineProperty2.default)(this, "feature", void 0);
    this.global = recordsToBasePrivilegeMap(rawKibanaPrivileges.global);
    this.spaces = recordsToBasePrivilegeMap(rawKibanaPrivileges.space);
    this.feature = new Map(features.map(feature => {
      const rawPrivs = rawKibanaPrivileges.features[feature.id];
      return [feature.id, new _secured_feature.SecuredFeature(feature.toRaw(), rawPrivs)];
    }));
  }
  getBasePrivileges(entry) {
    if ((0, _privilege_utils.isGlobalPrivilegeDefinition)(entry)) {
      return Array.from(this.global.values());
    }
    return Array.from(this.spaces.values());
  }
  getSecuredFeature(featureId) {
    return this.feature.get(featureId);
  }
  getSecuredFeatures() {
    return Array.from(this.feature.values());
  }
  createCollectionFromRoleKibanaPrivileges(roleKibanaPrivileges) {
    const filterAssigned = assignedPrivileges => privilege => Array.isArray(assignedPrivileges) && assignedPrivileges.includes(privilege.id);
    const privileges = roleKibanaPrivileges.map(entry => {
      const assignedBasePrivileges = this.getBasePrivileges(entry).filter(filterAssigned(entry.base));
      const assignedFeaturePrivileges = Object.entries(entry.feature).map(([featureId, assignedFeaturePrivs]) => {
        return this.getFeaturePrivileges(featureId).filter(filterAssigned(assignedFeaturePrivs));
      });
      return [assignedBasePrivileges, assignedFeaturePrivileges].flat(2);
    }).flat();
    return new _privilege_collection.PrivilegeCollection(privileges);
  }
  getFeaturePrivileges(featureId) {
    var _this$getSecuredFeatu, _this$getSecuredFeatu2;
    return (_this$getSecuredFeatu = (_this$getSecuredFeatu2 = this.getSecuredFeature(featureId)) === null || _this$getSecuredFeatu2 === void 0 ? void 0 : _this$getSecuredFeatu2.getAllPrivileges()) !== null && _this$getSecuredFeatu !== void 0 ? _this$getSecuredFeatu : [];
  }
}
exports.KibanaPrivileges = KibanaPrivileges;