"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api_keys = require("./api_keys");
var _role_mappings = require("./role_mappings");
var _roles = require("./roles");
var _users = require("./users");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ManagementService {
  constructor() {
    (0, _defineProperty2.default)(this, "license", void 0);
    (0, _defineProperty2.default)(this, "licenseFeaturesSubscription", void 0);
    (0, _defineProperty2.default)(this, "securitySection", void 0);
  }
  setup({
    getStartServices,
    management,
    authc,
    license,
    fatalErrors,
    uiConfig
  }) {
    this.license = license;
    this.securitySection = management.sections.section.security;
    if (!uiConfig || uiConfig.userManagementEnabled) {
      this.securitySection.registerApp(_users.usersManagementApp.create({
        authc,
        getStartServices
      }));
    }
    if (!uiConfig || uiConfig.roleManagementEnabled) {
      this.securitySection.registerApp(_roles.rolesManagementApp.create({
        fatalErrors,
        license,
        getStartServices
      }));
    }
    this.securitySection.registerApp(_api_keys.apiKeysManagementApp.create({
      authc,
      getStartServices
    }));
    if (!uiConfig || uiConfig.roleMappingManagementEnabled) {
      this.securitySection.registerApp(_role_mappings.roleMappingsManagementApp.create({
        getStartServices
      }));
    }
  }
  start({
    capabilities,
    uiConfig
  }) {
    this.licenseFeaturesSubscription = this.license.features$.subscribe(async features => {
      const securitySection = this.securitySection;
      const securityManagementAppsStatuses = [[securitySection.getApp(_api_keys.apiKeysManagementApp.id), features.showLinks]];
      if (!uiConfig || uiConfig.userManagementEnabled) {
        securityManagementAppsStatuses.push([securitySection.getApp(_users.usersManagementApp.id), features.showLinks]);
      }
      if (!uiConfig || uiConfig.roleManagementEnabled) {
        securityManagementAppsStatuses.push([securitySection.getApp(_roles.rolesManagementApp.id), features.showLinks]);
      }
      if (!uiConfig || uiConfig.roleMappingManagementEnabled) {
        securityManagementAppsStatuses.push([securitySection.getApp(_role_mappings.roleMappingsManagementApp.id), features.showLinks && features.showRoleMappingsManagement]);
      }

      // Iterate over all registered apps and update their enable status depending on the available
      // license features.
      for (const [app, enableStatus] of securityManagementAppsStatuses) {
        if (capabilities.management.security[app.id] !== true) {
          app.disable();
          continue;
        }
        if (app.enabled === enableStatus) {
          continue;
        }
        if (enableStatus) {
          app.enable();
        } else {
          app.disable();
        }
      }
    });
  }
  stop() {
    if (this.licenseFeaturesSubscription) {
      this.licenseFeaturesSubscription.unsubscribe();
      this.licenseFeaturesSubscription = undefined;
    }
  }
}
exports.ManagementService = ManagementService;