"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionalText = exports.FormRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _formik = require("formik");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component that renders a form row with all error states for inline validation.
 *
 * @example
 * ```typescript
 * <Formik>
 *   <FormRow label="Email">
 *     <FormField name="email" />
 *   </FormRow>
 * </Formik>
 * ```
 *
 * @throws Error if not a child of a `<Formik>` component.
 * @throws Error if `name` prop is not set and can't be inferred from its child element.
 */
const FormRow = props => {
  var _props$name;
  const formik = (0, _formik.useFormikContext)();
  const child = _react.Children.only(props.children);
  const name = (_props$name = props.name) !== null && _props$name !== void 0 ? _props$name : child.props.name;
  if (!name) {
    throw new Error('name prop is undefined, please verify you are either rendering <FormRow> itself or its child with a name prop.');
  }
  const meta = formik.getFieldMeta(name);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    error: meta.error,
    isInvalid: meta.touched && !!meta.error
  }, props), child);
};
exports.FormRow = FormRow;
const OptionalText = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.formRow.optionalText",
    defaultMessage: "Optional"
  }));
};
exports.OptionalText = OptionalText;