"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loginApp = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const loginApp = Object.freeze({
  id: 'security_login',
  create({
    application,
    http,
    getStartServices,
    config
  }) {
    http.anonymousPaths.register('/login');
    application.register({
      id: this.id,
      title: _i18n.i18n.translate('xpack.security.loginAppTitle', {
        defaultMessage: 'Login'
      }),
      chromeless: true,
      appRoute: '/login',
      async mount({
        element,
        theme$
      }) {
        const [[coreStart], {
          renderLoginPage
        }] = await Promise.all([getStartServices(), Promise.resolve().then(() => _interopRequireWildcard(require('./login_page')))]);
        return renderLoginPage(coreStart.i18n, {
          element,
          theme$
        }, {
          customBranding: coreStart.customBranding,
          http: coreStart.http,
          notifications: coreStart.notifications,
          fatalErrors: coreStart.fatalErrors,
          loginAssistanceMessage: config.loginAssistanceMessage,
          sameSiteCookies: config.sameSiteCookies
        });
      }
    });
  }
});
exports.loginApp = loginApp;