"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountManagementPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _model = require("../../common/model");
var _components = require("../components");
var _breadcrumb = require("../components/breadcrumb");
var _user_profile = require("./user_profile");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccountManagementPage = () => {
  var _userProfile$value;
  const {
    services
  } = (0, _public.useKibana)();
  const currentUser = (0, _components.useCurrentUser)();
  const userProfile = (0, _components.useUserProfile)('avatar,userSettings');

  // If we fail to load profile, we treat it as a failure _only_ if user is supposed
  // to have a profile. For example, anonymous and users authenticated via
  // authentication proxies don't have profiles.
  const profileLoadError = userProfile.error && currentUser.value && (0, _model.canUserHaveProfile)(currentUser.value) ? userProfile.error : undefined;
  const error = currentUser.error || profileLoadError;
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, error.message)
    });
  }
  if (!currentUser.value || (0, _model.canUserHaveProfile)(currentUser.value) && !userProfile.value) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    text: _i18n.i18n.translate('xpack.security.accountManagement.userSettingsBreadcrumbRootLabel', {
      defaultMessage: 'User settings'
    }),
    href: services.http.basePath.prepend('/security/account')
  }, /*#__PURE__*/_react.default.createElement(_user_profile.UserProfile, {
    user: currentUser.value,
    data: (_userProfile$value = userProfile.value) === null || _userProfile$value === void 0 ? void 0 : _userProfile$value.data
  }));
};
exports.AccountManagementPage = AccountManagementPage;