"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilerReadContext = exports.useProfilerActionContext = exports.ProfileContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _store = require("../store");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProfilerReadContext = /*#__PURE__*/(0, _react.createContext)(null);
const ProfilerActionContext = /*#__PURE__*/(0, _react.createContext)(null);
const ProfileContextProvider = ({
  children
}) => {
  const {
    dispatch,
    state
  } = (0, _store.useStore)();
  return /*#__PURE__*/_react.default.createElement(ProfilerReadContext.Provider, {
    value: state
  }, /*#__PURE__*/_react.default.createElement(ProfilerActionContext.Provider, {
    value: dispatch
  }, children));
};
exports.ProfileContextProvider = ProfileContextProvider;
const useProfilerReadContext = () => {
  const ctx = (0, _react.useContext)(ProfilerReadContext);
  if (ctx == null) {
    throw new Error(`useProfilerReadContext must be called inside ProfilerReadContext`);
  }
  return ctx;
};
exports.useProfilerReadContext = useProfilerReadContext;
const useProfilerActionContext = () => {
  const ctx = (0, _react.useContext)(ProfilerActionContext);
  if (ctx == null) {
    throw new Error(`useProfilerActionContext must be called inside ProfilerActionContext`);
  }
  return ctx;
};
exports.useProfilerActionContext = useProfilerActionContext;