"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ = require(".");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SavedSearchesService {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "get", savedSearchId => {
      const {
        search,
        contentManagement,
        spaces,
        savedObjectsTaggingOss
      } = this.deps;
      return (0, _.getSavedSearch)(savedSearchId, {
        search,
        contentManagement,
        spaces,
        savedObjectsTagging: savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi()
      });
    });
    (0, _defineProperty2.default)(this, "getAll", async () => {
      const {
        contentManagement
      } = this.deps;
      const result = await contentManagement.search({
        contentTypeId: _common.SavedSearchType,
        query: {}
      });
      return result.hits;
    });
    (0, _defineProperty2.default)(this, "getNew", () => (0, _.getNewSavedSearch)({
      search: this.deps.search
    }));
    (0, _defineProperty2.default)(this, "find", async search => {
      const {
        contentManagement
      } = this.deps;
      const result = await contentManagement.search({
        contentTypeId: _common.SavedSearchType,
        query: {
          text: search
        },
        options: {
          searchFields: ['title'],
          fields: ['title']
        }
      });
      return result.hits;
    });
    (0, _defineProperty2.default)(this, "save", (savedSearch, options = {}) => {
      const {
        contentManagement,
        savedObjectsTaggingOss
      } = this.deps;
      return (0, _.saveSavedSearch)(savedSearch, options, contentManagement, savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi());
    });
    this.deps = deps;
  }
}
exports.SavedSearchesService = SavedSearchesService;