"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedSearch = exports.getNewSavedSearch = void 0;
var _public = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
var _saved_searches_utils = require("./saved_searches_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getSavedSearchUrlConflictMessage = async json => _i18n.i18n.translate('savedSearch.legacyURLConflict.errorMessage', {
  defaultMessage: `This search has the same URL as a legacy alias. Disable the alias to resolve this error : {json}`,
  values: {
    json
  }
});
const getSavedSearch = async (savedSearchId, {
  search,
  spaces,
  savedObjectsTagging,
  contentManagement
}) => {
  var _savedSearch$attribut, _savedSearch$attribut2;
  const so = await contentManagement.get({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    id: savedSearchId
  });

  // @ts-expect-error
  if (so.error) {
    throw new Error(`Could not locate that search (id: ${savedSearchId})`);
  }
  if (so.meta.outcome === 'conflict') {
    var _await$spaces$getActi;
    throw new Error(await getSavedSearchUrlConflictMessage(JSON.stringify({
      targetType: _constants.SAVED_SEARCH_TYPE,
      sourceId: savedSearchId,
      targetSpace: (_await$spaces$getActi = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi === void 0 ? void 0 : _await$spaces$getActi.id
    })));
  }
  const savedSearch = so.item;
  const parsedSearchSourceJSON = (0, _public.parseSearchSourceJSON)((_savedSearch$attribut = (_savedSearch$attribut2 = savedSearch.attributes.kibanaSavedObjectMeta) === null || _savedSearch$attribut2 === void 0 ? void 0 : _savedSearch$attribut2.searchSourceJSON) !== null && _savedSearch$attribut !== void 0 ? _savedSearch$attribut : '{}');
  const searchSourceValues = (0, _public.injectSearchSourceReferences)(parsedSearchSourceJSON, savedSearch.references);
  const tags = savedObjectsTagging ? savedObjectsTagging.ui.getTagIdsFromReferences(savedSearch.references) : undefined;
  const returnVal = (0, _saved_searches_utils.fromSavedSearchAttributes)(savedSearchId, savedSearch.attributes, tags, savedSearch.references, await search.searchSource.create(searchSourceValues), so.meta);
  return returnVal;
};

/**
 * Returns a new saved search
 * Used when e.g. Discover is opened without a saved search id
 * @param search
 */
exports.getSavedSearch = getSavedSearch;
const getNewSavedSearch = ({
  search
}) => ({
  searchSource: search.searchSource.createEmpty()
});
exports.getNewSavedSearch = getNewSavedSearch;