"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.intializeSavedObject = intializeSavedObject;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Initialize saved object
 */
async function intializeSavedObject(savedObject, savedObjectsClient, config) {
  const esType = config.type;
  // ensure that the esType is defined
  if (!esType) throw new Error('You must define a type name to use SavedObject objects.');
  if (!savedObject.id) {
    // just assign the defaults and be done
    (0, _lodash.assign)(savedObject, savedObject.defaults);
    await savedObject.hydrateIndexPattern();
    if (typeof config.afterESResp === 'function') {
      savedObject = await config.afterESResp(savedObject);
    }
    return savedObject;
  }
  const resp = await savedObjectsClient.get(esType, savedObject.id);
  const respMapped = {
    _id: resp.id,
    _type: resp.type,
    _source: (0, _lodash.cloneDeep)(resp.attributes),
    references: resp.references,
    found: !!resp._version
  };
  await savedObject.applyESResp(respMapped);
  if (typeof config.init === 'function') {
    await config.init.call(savedObject);
  }
  return savedObject;
}