"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSaveModal = showSaveModal;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isSuccess(result) {
  return 'id' in result;
}
function showSaveModal(saveModal, Wrapper) {
  const container = document.createElement('div');
  const closeModal = () => {
    var _saveModal$props$onCl, _saveModal$props;
    _reactDom.default.unmountComponentAtNode(container);
    document.body.removeChild(container);
    (_saveModal$props$onCl = (_saveModal$props = saveModal.props).onClose) === null || _saveModal$props$onCl === void 0 ? void 0 : _saveModal$props$onCl.call(_saveModal$props);
  };
  const onSave = saveModal.props.onSave;
  const onSaveConfirmed = async (...args) => {
    const response = await onSave(...args);
    // close modal if we either hit an error or the saved object got an id
    if (Boolean(isSuccess(response) ? response.id : response.error)) {
      closeModal();
    }
    return response;
  };
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.cloneElement(saveModal, {
    onSave: onSaveConfirmed,
    onClose: closeModal
  });
  const I18nContext = (0, _kibana_services.getI18n)().Context;
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: (0, _kibana_services.getTheme)().theme$
  }, /*#__PURE__*/_react.default.createElement(I18nContext, null, Wrapper ? /*#__PURE__*/_react.default.createElement(Wrapper, null, element) : element)), container);
}