"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsForNotification = getAlertsForNotification;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAlertsForNotification(flappingSettings, trackedEventsToIndex) {
  return trackedEventsToIndex.map(trackedEvent => {
    if (!flappingSettings.enabled || trackedEvent.event[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE) {
      trackedEvent.pendingRecoveredCount = 0;
    } else if (flappingSettings.enabled && trackedEvent.event[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_RECOVERED) {
      if (trackedEvent.flapping) {
        const count = trackedEvent.pendingRecoveredCount || 0;
        trackedEvent.pendingRecoveredCount = count + 1;
        if (trackedEvent.pendingRecoveredCount < flappingSettings.statusChangeThreshold) {
          trackedEvent.event[_ruleDataUtils.ALERT_STATUS] = _ruleDataUtils.ALERT_STATUS_ACTIVE;
          trackedEvent.event[_ruleDataUtils.EVENT_ACTION] = 'active';
          delete trackedEvent.event[_ruleDataUtils.ALERT_END];
        } else {
          trackedEvent.pendingRecoveredCount = 0;
        }
      }
    }
    return trackedEvent;
  });
}